<style>

* {
  -webkit-box-sizing: border-box;
          box-sizing: border-box;
  margin: 0;
  padding: 0;
}

body,
html {
  height: 100%;
}

html {
  scroll-behavior: smooth;
}

html, body, div, span, img,
ol, ul, li, a, p, h1, h2, h3,
h4, h5, h6, option, legend, label,
table, th, td, tr, article, aside,
caption, figure, footer, header, hgroup,
mark, nav, section, time, audio, video {
  margin: 0;
  padding: 0;
  border: 0;
  outline: 0;
}

img {
  max-width: 100%;
}

a:hover, a:focus, a:active {
  text-decoration: none;
  outline: none !important;
  border: 0;
}

input:focus {
  outline: none;
}

input::-moz-focus-inner {
  border: 0;
  display: none;
}

input::-webkit-focus-inner {
  border: 0;
  display: none;
}

input:-webkit-autofill,
input:-webkit-autofill:hover,
input:-webkit-autofill:focus {
  -webkit-box-shadow: 0 0 0px 1000px white inset !important;
}

input:focus, textarea:focus, select:focus {
  outline: none;
}

::-webkit-input-placeholder {
  color: #666;
  opacity: 1;
  /* Firefox */
}

:-ms-input-placeholder {
  color: #666;
  opacity: 1;
  /* Firefox */
}

::-ms-input-placeholder {
  color: #666;
  opacity: 1;
  /* Firefox */
}

::placeholder {
  color: #666;
  opacity: 1;
  /* Firefox */
}

:-ms-input-placeholder {
  /* Internet Explorer 10-11 */
  color: #666;
}

::-ms-input-placeholder {
  /* Microsoft Edge */
  color: #666;
}

table {
  border-collapse: collapse;
}

html {
  margin: 0;
  padding: 0;
  width: 100%;
  height: 100%;
  overflow-y: scroll;
  overflow-x: hidden;
}

ul, li {
  margin: 0;
  padding: 0;
}

figure {
  margin: 0px;
}

form {
  position: relative;
}

.form-control:focus {
  outline: none !important;
  border: none !important;
  -webkit-box-shadow: 0 0 0;
          box-shadow: 0 0 0;
}

h1 a, h2 a, h3 a, h4 a, h5 a, h6 a {
  font-size: inherit;
  color: inherit;
  font-weight: inherit;
  line-height: inherit;
}

h1:hover a, h2:hover a, h3:hover a, h4:hover a, h5:hover a, h6:hover a {
  font-size: inherit;
  color: inherit;
  font-weight: inherit;
}

hr {
  margin: 0;
  padding: 0;
  border-color: #000;
}

ul {
  list-style-type: none;
}

li {
  list-style: none;
  position: relative;
}

a,
button {
  position: relative;
}

a:hover, a:focus,
button:hover,
button:focus {
  outline: 0;
  text-decoration: none;
}

input, textarea, button {
  border: 0px;
}

.container {
  width: 100%;
}

@media (min-width: 1300px) {
  .container {
    max-width: 1200px;
  }
}

/* ------------------------------------------------------------------
    Template All Variables Defined - Value Change with Your's Need
 -------------------------------------------------------------------- */
@font-face {
  font-family: 'Circular Std';
  src: url("../fonts/CircularStd-MediumItalic.eot");
  src: local("Circular Std Medium Italic"), local("CircularStd-MediumItalic"), url("../fonts/CircularStd-MediumItalic-1.eot") format("embedded-opentype"), url("../fonts/CircularStd-MediumItalic.woff2") format("woff2"), url("../fonts/CircularStd-MediumItalic.woff") format("woff"), url("../fonts/CircularStd-MediumItalic.ttf") format("truetype");
  font-weight: 500;
  font-style: italic;
}

@font-face {
  font-family: 'Circular Std';
  src: url("../fonts/CircularStd-Black.eot");
  src: local("Circular Std Black"), local("CircularStd-Black"), url("../fonts/CircularStd-Black-1.eot") format("embedded-opentype"), url("../fonts/CircularStd-Black.woff2") format("woff2"), url("../fonts/CircularStd-Black.woff") format("woff"), url("../fonts/CircularStd-Black.ttf") format("truetype");
  font-weight: 900;
  font-style: normal;
}

@font-face {
  font-family: 'Circular Std';
  src: url("../fonts/CircularStd-Medium.eot");
  src: local("Circular Std Medium"), local("CircularStd-Medium"), url("../fonts/CircularStd-Medium-1.eot") format("embedded-opentype"), url("../fonts/CircularStd-Medium.woff2") format("woff2"), url("../fonts/CircularStd-Medium.woff") format("woff"), url("../fonts/CircularStd-Medium.ttf") format("truetype");
  font-weight: 500;
  font-style: normal;
}

@font-face {
  font-family: 'Circular Std';
  src: url("../fonts/CircularStd-Bold.eot");
  src: local("Circular Std Bold"), local("CircularStd-Bold"), url("../fonts/CircularStd-Bold-1.eot") format("embedded-opentype"), url("../fonts/CircularStd-Bold.woff2") format("woff2"), url("../fonts/CircularStd-Bold.woff") format("woff"), url("../fonts/CircularStd-Bold.ttf") format("truetype");
  font-weight: bold;
  font-style: normal;
}

@font-face {
  font-family: 'Circular Std';
  src: url("../fonts/CircularStd-BlackItalic.eot");
  src: local("Circular Std Black Italic"), local("CircularStd-BlackItalic"), url("../fonts/CircularStd-BlackItalic-1.eot") format("embedded-opentype"), url("../fonts/CircularStd-BlackItalic.woff2") format("woff2"), url("../fonts/CircularStd-BlackItalic.woff") format("woff"), url("../fonts/CircularStd-BlackItalic.ttf") format("truetype");
  font-weight: 900;
  font-style: italic;
}

@font-face {
  font-family: 'Circular Std Book';
  src: url("../fonts/CircularStd-BookItalic.eot");
  src: local("Circular Std Book Italic"), local("CircularStd-BookItalic"), url("../fonts/CircularStd-BookItalic-1.eot") format("embedded-opentype"), url("../fonts/CircularStd-BookItalic.woff2") format("woff2"), url("../fonts/CircularStd-BookItalic.woff") format("woff"), url("../fonts/CircularStd-BookItalic.ttf") format("truetype");
  font-weight: normal;
  font-style: italic;
}

@font-face {
  font-family: 'Circular Std';
  src: url("../fonts/CircularStd-BoldItalic.eot");
  src: local("Circular Std Bold Italic"), local("CircularStd-BoldItalic"), url("../fonts/CircularStd-BoldItalic-1.eot") format("embedded-opentype"), url("../fonts/CircularStd-BoldItalic.woff2") format("woff2"), url("../fonts/CircularStd-BoldItalic.woff") format("woff"), url("../fonts/CircularStd-BoldItalic.ttf") format("truetype");
  font-weight: bold;
  font-style: italic;
}

@font-face {
  font-family: 'Circular Std Book';
  src: url("../fonts/CircularStd-Book.eot");
  src: local("Circular Std Book"), local("CircularStd-Book"), url("../fonts/CircularStd-Book-1.eot") format("embedded-opentype"), url("../fonts/CircularStd-Book.woff2") format("woff2"), url("../fonts/CircularStd-Book.woff") format("woff"), url("../fonts/CircularStd-Book.ttf") format("truetype");
  font-weight: normal;
  font-style: normal;
}

/* --------------------------------------------
    Template Default Fonts & Fonts Styles
 ---------------------------------------------- */
body {
  font-family: "Circular Std", sans-serif;
  font-size: 17px;
  font-weight: 400;
  line-height: 32px;
  color: #696969;
  background-color: #fff;
}

h1,
h2,
h3,
h4,
h5,
h6 {
  font-family: "Circular Std", sans-serif;
  margin: 0px;
  font-weight: 700;
  color: #211e3b;
}

h1 {
  font-size: 42px;
  line-height: 55px;
  letter-spacing: -3px;
}

@media (max-width: 767px) {
  h1 {
    font-size: 2rem;
    line-height: 3rem;
  }
}

h1.fs-lg {
  font-size: 150px;
  line-height: 80%;
}

@media (min-width: 767px) and (max-width: 991px) {
  h1.fs-lg {
    font-size: 42px;
  }
}

h2 {
  font-size: 36px;
  line-height: 130%;
  letter-spacing: -3px;
}

h3 {
  font-size: 22px;
  line-height: 30px;
}

h4 {
  font-size: 20px;
  line-height: 28px;
}

h5 {
  font-size: 18px;
  line-height: 26px;
}

h6 {
  font-size: 16px;
  line-height: 24px;
}

a {
  text-decoration: none;
  font-weight: 600;
  outline: none !important;
  cursor: pointer;
  font-size: 17px;
  line-height: 32px;
  -webkit-transition: all 0.4s ease-in-out;
  transition: all 0.4s ease-in-out;
  color: #211e3b;
}

p {
  margin: 0px;
}

.coverbg {
  background-repeat: no-repeat;
  background-position: 50% 50%;
  background-size: cover !important;
}

.mx-auto {
  margin: 0 auto;
}

.align-center {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-pack: center;
  -ms-flex-pack: center;
  justify-content: center;
  -webkit-box-align: center;
  -ms-flex-align: center;
  align-items: center;
}

.align-center:before, .align-center:after {
  content: none;
}

.align-center-h {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-pack: center;
  -ms-flex-pack: center;
  justify-content: center;
}

.align-center-h:before, .align-center-h:after {
  content: none;
}

.align-center-v {
  height: 100%;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-align: center;
  -ms-flex-align: center;
  align-items: center;
}

.align-center-v:before, .align-center-v:after {
  content: none;
}

.align-center-v-b {
  height: 100%;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-align: end;
  -ms-flex-align: end;
  align-items: flex-end;
}

.align-center-v-b:before, .align-center-v-b:after {
  content: none;
}

.justify-content-center {
  -webkit-box-pack: center !important;
  -ms-flex-pack: center !important;
  justify-content: center !important;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -ms-flex-wrap: wrap;
  flex-wrap: wrap;
}

.justify-content-center:before, .justify-content-center:after {
  content: none;
}

.eq-height {
  display: -webkit-box;
  display: -moz-flexbox;
  display: -ms-flexbox;
  display: -o-flexbox;
  display: flex;
  -ms-flex-wrap: wrap;
  -o-flex-wrap: wrap;
  flex-wrap: wrap;
}

.eq-height:before, .eq-height:after {
  content: none;
}

/* ----------------------------------
    Template Helps Classes - Styles
 ------------------------------------ */
.text-white h1,
.text-white h2,
.text-white h3,
.text-white h4,
.text-white h5,
.text-white h6,
.text-white p,
.text-white span,
.text-white a {
  color: #fff !important;
}

.mlm-30 {
  margin-left: -30px;
}

/* padding left */
.pl-5 {
  padding-left: 5px;
}

.pl-10 {
  padding-left: 10px;
}

.pl-15 {
  padding-left: 15px;
}

.pl-20 {
  padding-left: 20px;
}

.pl-25 {
  padding-left: 25px;
}

.pl-30 {
  padding-left: 30px;
}

.pl-35 {
  padding-left: 35px;
}

.pl-40 {
  padding-left: 40px;
}

.pl-45 {
  padding-left: 45px;
}

.pl-50 {
  padding-left: 50px;
}

.pl-60 {
  padding-left: 60px;
}

.pl-65 {
  padding-left: 65px;
}

.pl-70 {
  padding-left: 70px;
}

.pl-75 {
  padding-left: 75px;
}

.pl-80 {
  padding-left: 80px;
}

.pl-90 {
  padding-left: 90px;
}

.pl-100 {
  padding-left: 100px;
}

.pl-110 {
  padding-left: 110px;
}

.pl-115 {
  padding-left: 115px;
}

.pl-120 {
  padding-left: 120px;
}

.pl-125 {
  padding-left: 125px;
}

.pl-130 {
  padding-left: 130px;
}

.pl-140 {
  padding-left: 140px;
}

.pl-150 {
  padding-left: 150px;
}

/* padding right */
.pr-5 {
  padding-right: 5px;
}

.pr-5i {
  padding-right: 5px !important;
}

@media (max-width: 767px) {
  .pr-5i {
    padding-right: 15px !important;
  }
}

.pr-10 {
  padding-right: 10px;
}

.pr-15 {
  padding-right: 15px;
}

.pr-20 {
  padding-right: 20px;
}

.pr-25 {
  padding-right: 25px;
}

.pr-30 {
  padding-right: 30px;
}

.pr-35 {
  padding-right: 35px;
}

.pr-40 {
  padding-right: 40px;
}

.pr-45 {
  padding-right: 45px;
}

.pr-50 {
  padding-right: 50px;
}

.pr-60 {
  padding-right: 60px;
}

.pr-70 {
  padding-right: 70px;
}

.pr-75 {
  padding-right: 75px;
}

.pr-80 {
  padding-right: 80px;
}

.pr-90 {
  padding-right: 90px;
}

.pr-100 {
  padding-right: 100px;
}

.pr-110 {
  padding-right: 110px;
}

.pr-115 {
  padding-right: 115px;
}

.pr-120 {
  padding-right: 120px;
}

.pr-125 {
  padding-right: 125px;
}

.pr-130 {
  padding-right: 130px;
}

.pr-140 {
  padding-right: 140px;
}

.pr-150 {
  padding-right: 150px;
}

/* padding top */
.pt-5 {
  padding-top: 5px;
}

.pt-10 {
  padding-top: 10px;
}

.pt-15 {
  padding-top: 15px;
}

.pt-20 {
  padding-top: 20px;
}

.pt-25 {
  padding-top: 25px;
}

.pt-30 {
  padding-top: 30px;
}

.pt-35 {
  padding-top: 35px;
}

.pt-40 {
  padding-top: 40px;
}

.pt-45 {
  padding-top: 45px;
}

.pt-50 {
  padding-top: 50px;
}

.pt-60 {
  padding-top: 60px;
}

.pt-65 {
  padding-top: 65px;
}

.pt-70 {
  padding-top: 70px;
}

.pt-75 {
  padding-top: 75px;
}

.pt-80 {
  padding-top: 80px;
}

.pt-90 {
  padding-top: 90px;
}

.pt-100 {
  padding-top: 100px;
}

.pt-110 {
  padding-top: 110px;
}

.pt-115 {
  padding-top: 115px;
}

.pt-120 {
  padding-top: 120px;
}

.pt-125 {
  padding-top: 125px;
}

.pt-130 {
  padding-top: 130px;
}

.pt-140 {
  padding-top: 140px;
}

.pt-150 {
  padding-top: 150px;
}

/* padding bottom */
.pb-5 {
  padding-bottom: 5px;
}

.pb-10 {
  padding-bottom: 10px;
}

.pb-15 {
  padding-bottom: 15px;
}

.pb-20 {
  padding-bottom: 20px;
}

.pb-25 {
  padding-bottom: 25px;
}

.pb-30 {
  padding-bottom: 30px;
}

.pb-35 {
  padding-bottom: 35px;
}

.pb-40 {
  padding-bottom: 40px;
}

.pb-45 {
  padding-bottom: 45px;
}

.pb-50 {
  padding-bottom: 50px;
}

.pb-60 {
  padding-bottom: 60px;
}

.pb-65 {
  padding-bottom: 65px;
}

.pb-70 {
  padding-bottom: 70px;
}

.pb-75 {
  padding-bottom: 75px;
}

.pb-80 {
  padding-bottom: 80px;
}

.pb-90 {
  padding-bottom: 90px;
}

.pb-100 {
  padding-bottom: 100px;
}

.pb-110 {
  padding-bottom: 110px;
}

.pb-115 {
  padding-bottom: 115px;
}

.pb-120 {
  padding-bottom: 120px;
}

.pb-125 {
  padding-bottom: 125px;
}

.pb-130 {
  padding-bottom: 130px;
}

.pb-140 {
  padding-bottom: 140px;
}

.pb-150 {
  padding-bottom: 150px;
}

/* margin left */
.ml-5 {
  margin-left: 5px;
}

.ml-10 {
  margin-left: 10px;
}

.ml-15 {
  margin-left: 15px;
}

.ml-20 {
  margin-left: 20px;
}

.ml-25 {
  margin-left: 25px;
}

.ml-30 {
  margin-left: 30px;
}

.ml-35 {
  margin-left: 35px;
}

.ml-40 {
  margin-left: 40px;
}

.ml-45 {
  margin-left: 45px;
}

.ml-50 {
  margin-left: 50px;
}

.ml-60 {
  margin-left: 60px;
}

.ml-70 {
  margin-left: 70px;
}

.ml-75 {
  margin-left: 75px;
}

.ml-80 {
  margin-left: 80px;
}

.ml-90 {
  margin-left: 90px;
}

.ml-100 {
  margin-left: 100px;
}

.ml-110 {
  margin-left: 110px;
}

.ml-115 {
  margin-left: 115px;
}

.ml-120 {
  margin-left: 120px;
}

.ml-125 {
  margin-left: 125px;
}

.ml-130 {
  margin-left: 130px;
}

.ml-140 {
  margin-left: 140px;
}

.ml-150 {
  margin-left: 150px;
}

/* margin right */
.mr-5 {
  margin-right: 5px;
}

.mr-10 {
  margin-right: 10px;
}

.mr-15 {
  margin-right: 15px;
}

.mr-20 {
  margin-right: 20px;
}

.mr-25 {
  margin-right: 25px;
}

.mr-30 {
  margin-right: 30px;
}

.mr-35 {
  margin-right: 35px;
}

.mr-40 {
  margin-right: 40px;
}

.mr-45 {
  margin-right: 45px;
}

.mr-50 {
  margin-right: 50px;
}

.mr-60 {
  margin-right: 60px;
}

.mr-70 {
  margin-right: 70px;
}

.mr-75 {
  margin-right: 75px;
}

.mr-80 {
  margin-right: 80px;
}

.mr-90 {
  margin-right: 90px;
}

.mr-100 {
  margin-right: 100px;
}

.mr-110 {
  margin-right: 110px;
}

.mr-115 {
  margin-right: 115px;
}

.mr-120 {
  margin-right: 120px;
}

.mr-125 {
  margin-right: 125px;
}

.mr-130 {
  margin-right: 130px;
}

.mr-140 {
  margin-right: 140px;
}

.mr-150 {
  margin-right: 150px;
}

/* margin top */
.mt-5 {
  margin-top: 5px;
}

.mt-10 {
  margin-top: 10px;
}

.mt-15 {
  margin-top: 15px;
}

.mt-20 {
  margin-top: 20px;
}

.mt-25 {
  margin-top: 25px;
}

.mt-30 {
  margin-top: 30px;
}

.mt-35 {
  margin-top: 35px;
}

.mt-40 {
  margin-top: 40px;
}

.mt-45 {
  margin-top: 45px;
}

.mt-50 {
  margin-top: 50px;
}

.mt-60 {
  margin-top: 60px;
}

.mt-70 {
  margin-top: 70px;
}

.mt-75 {
  margin-top: 75px;
}

.mt-80 {
  margin-top: 80px;
}

.mt-90 {
  margin-top: 90px;
}

.mt-100 {
  margin-top: 100px;
}

.mt-110 {
  margin-top: 110px;
}

.mt-115 {
  margin-top: 115px;
}

.mt-120 {
  margin-top: 120px;
}

.mt-125 {
  margin-top: 125px;
}

.mt-130 {
  margin-top: 130px;
}

.mt-140 {
  margin-top: 140px;
}

.mt-150 {
  margin-top: 150px;
}

/* margin bottom */
.mb-5 {
  margin-bottom: 5px;
}

.mb-10 {
  margin-bottom: 10px;
}

.mb-15 {
  margin-bottom: 15px;
}

.mb-20 {
  margin-bottom: 20px;
}

.mb-25 {
  margin-bottom: 25px;
}

.mb-30 {
  margin-bottom: 30px;
}

.mb-35 {
  margin-bottom: 35px;
}

.mb-40 {
  margin-bottom: 40px;
}

.mb-45 {
  margin-bottom: 45px;
}

.mb-50 {
  margin-bottom: 50px;
}

.mb-55 {
  margin-bottom: 55px;
}

.mb-60 {
  margin-bottom: 60px;
}

.mb-70 {
  margin-bottom: 70px;
}

.mb-75 {
  margin-bottom: 75px;
}

.mb-80 {
  margin-bottom: 80px;
}

.mb-90 {
  margin-bottom: 90px;
}

.mb-100 {
  margin-bottom: 100px;
}

.mb-110 {
  margin-bottom: 110px;
}

.mb-115 {
  margin-bottom: 115px;
}

.mb-120 {
  margin-bottom: 120px;
}

.mb-125 {
  margin-bottom: 125px;
}

.mb-130 {
  margin-bottom: 130px;
}

.mb-140 {
  margin-bottom: 140px;
}

.mb-150 {
  margin-bottom: 150px;
}

.mmb10 {
  margin-bottom: -10px;
}

.mtm-30 {
  margin-top: -30px;
}

.mbm-30 {
  margin-bottom: -30px;
}

.mtm-40 {
  margin-bottom: -40px;
}

@media (max-width: 767px) {
  .mpt-50 {
    padding-top: 50px !important;
  }
}

/* background */
.bg-cover {
  background-repeat: no-repeat;
  background-size: cover;
  position: relative;
  background-position: center;
}

.bg-center {
  background-position: center;
}

.bg-contain {
  background-repeat: no-repeat;
  background-size: contain;
  position: relative;
  background-position: left;
}

.bg-right {
  background-repeat: no-repeat;
  background-position: right;
}

.bg-left {
  background-repeat: no-repeat;
  background-position: left;
}

.bg-bottom {
  background-repeat: no-repeat;
  background-position: bottom;
}

.bg-top {
  background-repeat: no-repeat;
  background-position: top;
}

.bg-100 {
  background-size: 100% 100%;
}

.mmb-100 {
  margin-bottom: -100px;
}

.mmb-80 {
  margin-bottom: -80px;
}

.lr-9 {
  margin-left: -9px;
  margin-right: -9px;
}

.lr-9 [class*="col"] {
  padding-left: 9px;
  padding-right: 9px;
}

.triangle {
  width: 0;
  height: 0;
}

.triangle.triangle-top-left {
  border-top: 100px solid #32557f;
  border-right: 100px solid transparent;
}

.triangle.triangle-top-right {
  border-top: 100px solid #32557f;
  border-left: 100px solid transparent;
}

.triangle.triangle-bottom-left {
  border-bottom: 100px solid #32557f;
  border-right: 100px solid transparent;
}

.triangle.triangle-bottom-right {
  border-bottom: 100px solid #32557f;
  border-left: 100px solid transparent;
}

.bg-overlay {
  position: relative;
  z-index: 1;
}

.bg-overlay::before {
  position: absolute;
  left: 0;
  content: "";
  top: 0;
  width: 100%;
  height: 100%;
  opacity: .8;
  background-color: #000;
  z-index: -1;
}

.fix {
  position: relative;
  overflow: hidden;
  z-index: 1;
}

.shape {
  position: absolute;
}

@media (max-width: 1191px) {
  .shape {
    display: none;
    opacity: 0;
  }
}

.navbar-brand {
  padding: 0;
  margin-right: 0;
}

#scrollUp {
  background-color: <?=$ayar['renk']?>;
  border-radius: 50%;
  bottom: 20px;
  color: #ffffff;
  font-size: 22px;
  height: 40px;
  line-height: 44px;
  right: 20px;
  text-align: center;
  width: 40px;
  -webkit-box-shadow: 0px 5px 15px 0px rgba(1, 29, 80, 0.1);
          box-shadow: 0px 5px 15px 0px rgba(1, 29, 80, 0.1);
  font-weight: 400;
  -webkit-transition: all 0.4s ease-in-out;
  transition: all 0.4s ease-in-out;
}

#scrollUp:hover {
  background-color: #211e3b;
}

@media only screen and (max-width: 991px) {
  #scrollUp {
    font-size: 15px;
    height: 30px;
    line-height: 34px;
    right: 30px;
    width: 30px;
  }
}

button {
  border: none;
}

.clear-fix {
  overflow: hidden;
}

section {
  position: relative;
  z-index: 1;
}

section.pt-235 {
  padding-top: 225px;
}

@-webkit-keyframes sticky {
  0% {
    opacity: 0;
    margin-top: -120px;
  }
  50% {
    opacity: 0;
    margin-top: -60px;
  }
  100% {
    opacity: 1;
    margin-top: 0;
  }
}

@keyframes sticky {
  0% {
    opacity: 0;
    margin-top: -120px;
  }
  50% {
    opacity: 0;
    margin-top: -60px;
  }
  100% {
    opacity: 1;
    margin-top: 0;
  }
}

.equal {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -ms-flex-wrap: wrap;
      flex-wrap: wrap;
}

.equal > [class*='col-'] {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-orient: vertical;
  -webkit-box-direction: normal;
      -ms-flex-direction: column;
          flex-direction: column;
}

@media (max-width: 414px) {
  .d-none-mobile {
    display: none !important;
  }
}

.overlay {
  -webkit-transition: all .2s ease-in-out;
  transition: all .2s ease-in-out;
  width: 40%;
  opacity: 0;
  visibility: hidden;
  cursor: url("../img/icon/close-icon.svg") 15 15, auto;
}

.overlay.active {
  position: fixed;
  right: 0;
  top: 0;
  height: 100%;
  width: 100%;
  content: "";
  background-color: #000;
  z-index: 99;
  opacity: .5;
  visibility: visible;
}

.dark-bg {
  background-color: #000;
}

.dark-bg h1, .dark-bg h2, .dark-bg h3, .dark-bg h4, .dark-bg h5, .dark-bg h6, .dark-bg a {
  color: #FFF;
}

.dark-bg p {
  color: #cacaca;
}

.no-padding .col-12 {
  padding: 0;
}

img.alignright {
  float: right;
  margin: 0 0 1em 1em;
}

img.alignleft {
  float: left;
  margin: 0 1em 1em 0;
}

img.aligncenter {
  display: block;
  margin-left: auto;
  margin-right: auto;
}

a img.alignright {
  float: right;
  margin: 0 0 1em 1em;
}

a img.alignleft {
  float: left;
  margin: 0 1em 1em 0;
}

a img.aligncenter {
  display: block;
  margin-left: auto;
  margin-right: auto;
}

@-webkit-keyframes left-to-right {
  0% {
    background-position: left center;
  }
  100% {
    background-position: right center;
  }
}

@keyframes left-to-right {
  0% {
    background-position: left center;
  }
  100% {
    background-position: right center;
  }
}

@-webkit-keyframes right-to-left {
  0% {
    background-position: right center;
  }
  100% {
    background-position: left center;
  }
}

@keyframes right-to-left {
  0% {
    background-position: right center;
  }
  100% {
    background-position: left center;
  }
}

@-webkit-keyframes left-to-center {
  0% {
    background-position: left center;
  }
  100% {
    background-position: center center;
  }
}

@keyframes left-to-center {
  0% {
    background-position: left center;
  }
  100% {
    background-position: center center;
  }
}

@-webkit-keyframes right-to-center {
  0% {
    background-position: right center;
  }
  100% {
    background-position: center center;
  }
}

@keyframes right-to-center {
  0% {
    background-position: right center;
  }
  100% {
    background-position: center center;
  }
}

@-webkit-keyframes top-to-bottom {
  0% {
    background-position: center top;
  }
  100% {
    background-position: center bottom;
  }
}

@keyframes top-to-bottom {
  0% {
    background-position: center top;
  }
  100% {
    background-position: center bottom;
  }
}

@-webkit-keyframes top-to-center {
  0% {
    background-position: center top;
  }
  100% {
    background-position: center center;
  }
}

@keyframes top-to-center {
  0% {
    background-position: center top;
  }
  100% {
    background-position: center center;
  }
}

@-webkit-keyframes bottom-to-top {
  0% {
    background-position: center bottom;
  }
  100% {
    background-position: center top;
  }
}

@keyframes bottom-to-top {
  0% {
    background-position: center bottom;
  }
  100% {
    background-position: center top;
  }
}

@-webkit-keyframes bottom-to-center {
  0% {
    background-position: center bottom;
  }
  100% {
    background-position: center center;
  }
}

@keyframes bottom-to-center {
  0% {
    background-position: center bottom;
  }
  100% {
    background-position: center center;
  }
}

@-webkit-keyframes top-left-to-bottom-right {
  0% {
    background-position: left top;
  }
  100% {
    background-position: right bottom;
  }
}

@keyframes top-left-to-bottom-right {
  0% {
    background-position: left top;
  }
  100% {
    background-position: right bottom;
  }
}

@-webkit-keyframes top-left-to-center {
  0% {
    background-position: left top;
  }
  100% {
    background-position: center center;
  }
}

@keyframes top-left-to-center {
  0% {
    background-position: left top;
  }
  100% {
    background-position: center center;
  }
}

@-webkit-keyframes top-right-to-bottom-left {
  0% {
    background-position: right top;
  }
  100% {
    background-position: left bottom;
  }
}

@keyframes top-right-to-bottom-left {
  0% {
    background-position: right top;
  }
  100% {
    background-position: left bottom;
  }
}

@-webkit-keyframes top-right-to-center {
  0% {
    background-position: right top;
  }
  100% {
    background-position: center center;
  }
}

@keyframes top-right-to-center {
  0% {
    background-position: right top;
  }
  100% {
    background-position: center center;
  }
}

@-webkit-keyframes bottom-left-to-top-right {
  0% {
    background-position: left bottom;
  }
  100% {
    background-position: right top;
  }
}

@keyframes bottom-left-to-top-right {
  0% {
    background-position: left bottom;
  }
  100% {
    background-position: right top;
  }
}

@-webkit-keyframes bottom-left-to-center {
  0% {
    background-position: left bottom;
  }
  100% {
    background-position: center center;
  }
}

@keyframes bottom-left-to-center {
  0% {
    background-position: left bottom;
  }
  100% {
    background-position: center center;
  }
}

@-webkit-keyframes bottom-right-to-top-left {
  0% {
    background-position: right bottom;
  }
  100% {
    background-position: left top;
  }
}

@keyframes bottom-right-to-top-left {
  0% {
    background-position: right bottom;
  }
  100% {
    background-position: left top;
  }
}

@-webkit-keyframes bottom-right-to-center {
  0% {
    background-position: right bottom;
  }
  100% {
    background-position: center center;
  }
}

@keyframes bottom-right-to-center {
  0% {
    background-position: right bottom;
  }
  100% {
    background-position: center center;
  }
}

@-webkit-keyframes zoomIn {
  0% {
    background-position: right center;
  }
  100% {
    background-position: left center;
  }
}

@keyframes zoomIn {
  0% {
    background-position: right center;
  }
  100% {
    background-position: left center;
  }
}

.animation_left-to-right {
  background-position: left center;
}

.active .animation_left-to-right {
  -webkit-animation: left-to-right 5s ease 0s 1 normal forwards running;
          animation: left-to-right 5s ease 0s 1 normal forwards running;
}

.animation_right-to-left {
  background-position: right center;
}

.active .animation_right-to-left {
  -webkit-animation: right-to-left 5s ease 0s 1 normal forwards running;
          animation: right-to-left 5s ease 0s 1 normal forwards running;
}

.animation_left-to-center {
  background-position: left center;
}

.active .animation_left-to-center {
  -webkit-animation: left-to-center 5s ease 0s 1 normal forwards running;
          animation: left-to-center 5s ease 0s 1 normal forwards running;
}

.animation_right-to-center {
  background-position: right center;
}

.active .animation_right-to-center {
  -webkit-animation: right-to-center 5s ease 0s 1 normal forwards running;
          animation: right-to-center 5s ease 0s 1 normal forwards running;
}

.animation_top-to-bottom {
  background-position: center top;
}

.active .animation_top-to-bottom {
  -webkit-animation: top-to-bottom 5s ease 0s 1 normal forwards running;
          animation: top-to-bottom 5s ease 0s 1 normal forwards running;
}

.animation_top-to-center {
  background-position: center top;
}

.active .animation_top-to-center {
  -webkit-animation: top-to-center 5s ease 0s 1 normal forwards running;
          animation: top-to-center 5s ease 0s 1 normal forwards running;
}

.animation_bottom-to-top {
  background-position: center bottom;
}

.active .animation_bottom-to-top {
  -webkit-animation: bottom-to-top 5s ease 0s 1 normal forwards running;
          animation: bottom-to-top 5s ease 0s 1 normal forwards running;
}

.animation_bottom-to-center {
  background-position: center bottom;
}

.active .animation_bottom-to-center {
  -webkit-animation: bottom-to-center 5s ease 0s 1 normal forwards running;
          animation: bottom-to-center 5s ease 0s 1 normal forwards running;
}

.animation_top-left-to-bottom-right {
  background-position: left top;
}

.active .animation_top-left-to-bottom-right {
  -webkit-animation: top-left-to-bottom-right 5s ease 0s 1 normal forwards running;
          animation: top-left-to-bottom-right 5s ease 0s 1 normal forwards running;
}

.animation_top-left-to-center {
  background-position: left top;
}

.active .animation_top-left-to-center {
  -webkit-animation: top-left-to-center 5s ease 0s 1 normal forwards running;
          animation: top-left-to-center 5s ease 0s 1 normal forwards running;
}

.animation_top-right-to-bottom-left {
  background-position: right top;
}

.active .animation_top-right-to-bottom-left {
  -webkit-animation: top-right-to-bottom-left 5s ease 0s 1 normal forwards running;
          animation: top-right-to-bottom-left 5s ease 0s 1 normal forwards running;
}

.animation_top-right-to-center {
  background-position: right top;
}

.active .animation_top-right-to-center {
  -webkit-animation: top-right-to-center 5s ease 0s 1 normal forwards running;
          animation: top-right-to-center 5s ease 0s 1 normal forwards running;
}

.animation_bottom-left-to-top-right {
  background-position: left bottom;
}

.active .animation_bottom-left-to-top-right {
  -webkit-animation: bottom-left-to-top-right 5s ease 0s 1 normal forwards running;
          animation: bottom-left-to-top-right 5s ease 0s 1 normal forwards running;
}

.animation_bottom-left-to-center {
  background-position: left bottom;
}

.active .animation_bottom-left-to-center {
  -webkit-animation: bottom-left-to-center 5s ease 0s 1 normal forwards running;
          animation: bottom-left-to-center 5s ease 0s 1 normal forwards running;
}

.animation_bottom-right-to-top-left {
  background-position: right bottom;
}

.active .animation_bottom-right-to-top-left {
  -webkit-animation: bottom-right-to-top-left 5s ease 0s 1 normal forwards running;
          animation: bottom-right-to-top-left 5s ease 0s 1 normal forwards running;
}

.animation_bottom-right-to-center {
  background-position: right bottom;
}

.active .animation_bottom-right-to-center {
  -webkit-animation: bottom-right-to-center 5s ease 0s 1 normal forwards running;
          animation: bottom-right-to-center 5s ease 0s 1 normal forwards running;
}

/* Alignments
--------------------------------------------- */
.alignleft {
  /*rtl:ignore*/
  float: left;
  /*rtl:ignore*/
  margin-right: 1.5em;
  margin-bottom: 1.5em;
}

.alignright {
  /*rtl:ignore*/
  float: right;
  /*rtl:ignore*/
  margin-left: 1.5em;
  margin-bottom: 1.5em;
}

.aligncenter {
  clear: both;
  display: block;
  margin-left: auto;
  margin-right: auto;
  margin-bottom: 1.5em;
}

@-webkit-keyframes playVideo {
  0% {
    -webkit-box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.3);
    box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.3);
  }
  40% {
    -webkit-box-shadow: 0 0 0 20px rgba(255, 255, 255, 0);
    box-shadow: 0 0 0 20px rgba(255, 255, 255, 0);
  }
  80% {
    -webkit-box-shadow: 0 0 0 20px rgba(255, 255, 255, 0);
    box-shadow: 0 0 0 20px rgba(255, 255, 255, 0);
  }
  100% {
    -webkit-box-shadow: 0 0 0 0 rgba(255, 255, 255, 0);
    box-shadow: 0 0 0 0 rgba(255, 255, 255, 0);
  }
}

@keyframes playVideo {
  0% {
    -webkit-box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.3);
    box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.3);
  }
  40% {
    -webkit-box-shadow: 0 0 0 20px rgba(255, 255, 255, 0);
    box-shadow: 0 0 0 20px rgba(255, 255, 255, 0);
  }
  80% {
    -webkit-box-shadow: 0 0 0 20px rgba(255, 255, 255, 0);
    box-shadow: 0 0 0 20px rgba(255, 255, 255, 0);
  }
  100% {
    -webkit-box-shadow: 0 0 0 0 rgba(255, 255, 255, 0);
    box-shadow: 0 0 0 0 rgba(255, 255, 255, 0);
  }
}

@-webkit-keyframes dimond {
  0% {
    -webkit-transform: rotate(0deg);
            transform: rotate(0deg);
  }
  100% {
    -webkit-transform: rotate(360deg);
            transform: rotate(360deg);
  }
}

@keyframes dimond {
  0% {
    -webkit-transform: rotate(0deg);
            transform: rotate(0deg);
  }
  100% {
    -webkit-transform: rotate(360deg);
            transform: rotate(360deg);
  }
}

@-webkit-keyframes bounce {
  0%, 100% {
    -webkit-transform: scale(0);
  }
  50% {
    -webkit-transform: scale(1);
  }
}

@keyframes bounce {
  0%, 100% {
    transform: scale(0);
    -webkit-transform: scale(0);
  }
  50% {
    transform: scale(1);
    -webkit-transform: scale(1);
  }
}

@-webkit-keyframes movebounce {
  0% {
    -webkit-transform: translateY(0px);
    transform: translateY(0px);
  }
  50% {
    -webkit-transform: translateY(20px);
    transform: translateY(20px);
  }
  100% {
    -webkit-transform: translateY(0px);
    transform: translateY(0px);
  }
}

@keyframes movebounce {
  0% {
    -webkit-transform: translateY(0px);
    transform: translateY(0px);
  }
  50% {
    -webkit-transform: translateY(20px);
    transform: translateY(20px);
  }
  100% {
    -webkit-transform: translateY(0px);
    transform: translateY(0px);
  }
}

@-webkit-keyframes bounceUp {
  0% {
    -webkit-transform: translateY(0px);
    transform: translateY(0px);
  }
  50% {
    -webkit-transform: translateY(40px);
    transform: translateY(40px);
  }
  100% {
    -webkit-transform: translateY(0px);
    transform: translateY(0px);
  }
}

@keyframes bounceUp {
  0% {
    -webkit-transform: translateY(0px);
    transform: translateY(0px);
  }
  50% {
    -webkit-transform: translateY(40px);
    transform: translateY(40px);
  }
  100% {
    -webkit-transform: translateY(0px);
    transform: translateY(0px);
  }
}

@-webkit-keyframes moveleftbounce {
  0% {
    -webkit-transform: translateX(0px);
    transform: translateX(0px);
  }
  50% {
    -webkit-transform: translateX(40px);
    transform: translateX(40px);
  }
  100% {
    -webkit-transform: translateX(0px);
    transform: translateX(0px);
  }
}

@keyframes moveleftbounce {
  0% {
    -webkit-transform: translateX(0px);
    transform: translateX(0px);
  }
  50% {
    -webkit-transform: translateX(40px);
    transform: translateX(40px);
  }
  100% {
    -webkit-transform: translateX(0px);
    transform: translateX(0px);
  }
}

@-webkit-keyframes moverightbounce {
  0% {
    margin-left: 0px;
  }
  50% {
    margin-left: 30px;
  }
  100% {
    margin-left: 0px;
  }
}

@keyframes moverightbounce {
  0% {
    margin-left: 0px;
  }
  50% {
    margin-left: 30px;
  }
  100% {
    margin-left: 0px;
  }
}

.rotateme {
  -webkit-animation-name: rotateme;
  animation-name: rotateme;
  -webkit-animation-duration: 20s;
  animation-duration: 20s;
  -webkit-animation-iteration-count: infinite;
  animation-iteration-count: infinite;
  -webkit-animation-timing-function: linear;
  animation-timing-function: linear;
}

@keyframes guraguri {
  from {
    -webkit-transform: rotate(0deg);
    transform: rotate(0deg);


  }
  to {
    -webkit-transform: rotate(360deg);
    transform: rotate(360deg);
  }
}

@-webkit-keyframes guraguri {
  from {
    -webkit-transform: rotate(0deg);
  }
  to {
    -webkit-transform: rotate(360deg);
  }
}

@-webkit-keyframes rotate3d {
  0% {
    -webkit-transform: rotateY(0deg);
    transform: rotateY(0deg);
  }
  100% {
    -webkit-transform: rotateY(360deg);
    transform: rotateY(360deg);
  }
}

@keyframes rotate3d {
  0% {
    -webkit-transform: rotateY(0deg);
    transform: rotateY(0deg);
  }
  100% {
    -webkit-transform: rotateY(360deg);
    transform: rotateY(360deg);
  }
}

@keyframes move_wave {
  0% {
    -webkit-transform: translateX(0) translateZ(0) scaleY(1);
            transform: translateX(0) translateZ(0) scaleY(1);
  }
  50% {
    -webkit-transform: translateX(-25%) translateZ(0) scaleY(0.55);
            transform: translateX(-25%) translateZ(0) scaleY(0.55);
  }
  100% {
    -webkit-transform: translateX(-50%) translateZ(0) scaleY(1);
            transform: translateX(-50%) translateZ(0) scaleY(1);
  }
}

@-webkit-keyframes move_wave {
  0% {
    -webkit-transform: translateX(0) translateZ(0) scaleY(1);
            transform: translateX(0) translateZ(0) scaleY(1);
  }
  50% {
    -webkit-transform: translateX(-25%) translateZ(0) scaleY(0.55);
            transform: translateX(-25%) translateZ(0) scaleY(0.55);
  }
  100% {
    -webkit-transform: translateX(-50%) translateZ(0) scaleY(1);
            transform: translateX(-50%) translateZ(0) scaleY(1);
  }
}

/* ----------------------------------
  All Aniamtion Styles
 ------------------------------------ */
/* ------------------------------------------------------------------
   Template Default Button, Input Styles - Value Change with Your's Need
 -------------------------------------------------------------------- */
.btnd, .theme-btn, .video-btn {
  line-height: 1;
  display: inline-block;
  -webkit-transition: all 0.4s ease-in-out;
  transition: all 0.4s ease-in-out;
  text-transform: uppercase;
}

.theme-btn {
  color: #FFF;
  padding: 20px 40px;
  border-radius: 5px;
  font-size: 14px;
  background-color: <?=$ayar['renk']?>;
  border: 1px solid <?=$ayar['renk']?>;
  -webkit-box-sizing: border-box;
          box-sizing: border-box;
}

.theme-btn.theme-2 {
  background-color: #ff5e14;
  border: 1px solid #ff5e14;
  color: #fff;
  border-radius: 50px;
  padding: 22px 40px;
}

.theme-btn.theme-2:hover {
  background-color: #211e3b;
  border: 1px solid #211e3b;
}

.theme-btn.theme-2.white {
  background: #fff;
  -webkit-box-shadow: 0px 16px 32px 0px rgba(0, 0, 0, 0.1);
          box-shadow: 0px 16px 32px 0px rgba(0, 0, 0, 0.1);
  color: #211e3b;
  border-color: #fff;
}

.theme-btn.theme-2.white:hover {
  background-color: #211e3b;
  color: #fff;
  border-color: #211e3b;
}

@media (max-width: 767px) {
  .theme-btn {
    padding: 17px 30px;
    font-size: 13px;
  }
}

@media (max-width: 580px) {
  .theme-btn {
    padding: 16px 26px;
  }
}

@media (max-width: 480px) {
  .theme-btn {
    padding: 15px 25px;
  }
}

.theme-btn i {
  margin-left: 10px;
}

.theme-btn.no-fil {
  background-color: transparent;
  border-color: rgba(255, 255, 255, 0.2);
  -webkit-box-shadow: inherit;
          box-shadow: inherit;
  margin-left: 15px;
}

@media (max-width: 500px) {
  .theme-btn.no-fil {
    margin-left: 0;
  }
}

.theme-btn.no-fil:hover {
  background-color: <?=$ayar['renk']?>;
  border: 1px solid <?=$ayar['renk']?>;
}

.theme-btn.black {
  background-color: #000;
  border-color: #000;
  -webkit-box-shadow: inherit;
          box-shadow: inherit;
  color: #FFF;
}

.theme-btn.black:hover {
  background-color: <?=$ayar['renk']?>;
  border: 1px solid <?=$ayar['renk']?>;
}

.theme-btn.minimal-btn {
  color: #211e3b;
  border: 1px solid #b0cff2;
  background: transparent;
  -webkit-box-shadow: inherit;
          box-shadow: inherit;
}

.theme-btn.minimal-btn:hover {
  background-color: <?=$ayar['renk']?>;
  border: 1px solid <?=$ayar['renk']?>;
  -webkit-box-shadow: inherit;
          box-shadow: inherit;
  color: #FFF;
}

.theme-btn.off-white {
  background-color: #efeff1;
  color: #211e3b;
  border: 1px solid #efeff1;
}

.theme-btn:hover {
  background-color: #000;
  border: 1px solid #000;
  -webkit-box-shadow: inherit;
          box-shadow: inherit;
  color: #FFF;
}

.video-btn {
  font-size: 16px;
  font-weight: 700;
  color: <?=$ayar['renk']?>;
}

.video-btn i {
  margin-right: 10px;
}

.video-play-btn .play-video {
  border-radius: 50%;
  width: 100px;
  height: 100px;
  background-color: #fff;
  color: <?=$ayar['renk']?>;
  line-height: 100px;
  -webkit-transition: .3s;
  transition: .3s;
  text-align: center;
  -webkit-animation: playVideo infinite 3s;
          animation: playVideo infinite 3s;
  display: inline-block;
  margin: 0px auto;
  font-size: 18px;
}

@media (max-width: 767px) {
  .video-play-btn .play-video {
    width: 80px;
    height: 80px;
    line-height: 80px;
  }
}

.video-play-btn .play-video:hover {
  color: <?=$ayar['renk']?>;
  -webkit-box-shadow: 0 14px 28px rgba(0, 0, 0, 0.25), 0 10px 10px rgba(0, 0, 0, 0.22);
          box-shadow: 0 14px 28px rgba(0, 0, 0, 0.25), 0 10px 10px rgba(0, 0, 0, 0.22);
}

.video-play-btn .play-text {
  font-weight: 700;
}

.cat-btn {
  font-size: 16px;
  line-height: 1;
  padding: 20px 30px;
  font-weight: 700;
  border-style: solid;
  border-width: 2px;
  border-color: rgba(255, 255, 255, 0.2);
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
  background: transparent;
  display: inline-block;
  margin-right: 10px;
  margin-top: 30px;
}

.cat-btn i {
  margin-right: 10px;
}

.cat-btn.color {
  background-color: #00baa3;
  border-color: #00baa3;
  color: #fff;
}

.cat-btn:hover {
  background-color: #00baa3;
  border-color: #00baa3;
  border-style: solid;
  border-width: 2px;
}

.preloader {
  -webkit-box-align: center;
  -ms-flex-align: center;
  align-items: center;
  cursor: default;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  height: 100%;
  -webkit-box-pack: center;
  -ms-flex-pack: center;
  justify-content: center;
  position: fixed;
  left: 0;
  top: 0;
  width: 100%;
  z-index: 999999999;
}

.preloader .animation-preloader {
  z-index: 1000;
}

.preloader .animation-preloader .spinner {
  -webkit-animation: spinner 1s infinite linear;
  animation: spinner 1s infinite linear;
  border-radius: 50%;
  border: 3px solid rgba(0, 0, 0, 0.2);
  border-top-color: #000000;
  height: 9em;
  margin: 0 auto 3.5em auto;
  width: 9em;
}

.preloader .animation-preloader .txt-loading {
  font: 700 5em "Circular Std", sans-serif, sans-serif;
  text-align: center;
  -webkit-user-select: none;
  -moz-user-select: none;
  -ms-user-select: none;
  user-select: none;
}

@media (max-width: 500px) {
  .preloader .animation-preloader .txt-loading {
    font-size: 3em;
  }
}

.preloader .animation-preloader .txt-loading .letters-loading {
  color: <?=$ayar['renk']?>;
  position: relative;
}

.preloader .animation-preloader .txt-loading .letters-loading:before {
  -webkit-animation: letters-loading 4s infinite;
  animation: letters-loading 4s infinite;
  color: <?=$ayar['renk']?>;
  content: attr(data-text-preloader);
  left: 0;
  opacity: 0;
  font-family: "Circular Std", sans-serif;
  position: absolute;
  top: -3px;
  -webkit-transform: rotateY(-90deg);
  transform: rotateY(-90deg);
}

.preloader .animation-preloader .txt-loading .letters-loading:nth-child(2):before {
  -webkit-animation-delay: 0.2s;
  animation-delay: 0.2s;
}

.preloader .animation-preloader .txt-loading .letters-loading:nth-child(3):before {
  -webkit-animation-delay: 0.4s;
  animation-delay: 0.4s;
}

.preloader .animation-preloader .txt-loading .letters-loading:nth-child(4):before {
  -webkit-animation-delay: 0.6s;
  animation-delay: 0.6s;
}

.preloader .animation-preloader .txt-loading .letters-loading:nth-child(5):before {
  -webkit-animation-delay: 0.8s;
  animation-delay: 0.8s;
}

.preloader .animation-preloader .txt-loading .letters-loading:nth-child(6):before {
  -webkit-animation-delay: 1s;
  animation-delay: 1s;
}

.preloader .animation-preloader .txt-loading .letters-loading:nth-child(7):before {
  -webkit-animation-delay: 1.2s;
  animation-delay: 1.2s;
}

.preloader .animation-preloader .txt-loading .letters-loading:nth-child(8):before {
  -webkit-animation-delay: 1.4s;
  animation-delay: 1.4s;
}

.preloader.dark .animation-preloader .spinner {
  border-color: <?=$ayar['renk']?>;
  border-top-color: #fff;
}

.preloader.dark .animation-preloader .txt-loading .letters-loading {
  color: <?=$ayar['renk']?>;
}

.preloader.dark .animation-preloader .txt-loading .letters-loading:before {
  color: <?=$ayar['renk']?>;
}

.preloader p {
  font-size: 14px;
  font-weight: 500;
  text-transform: uppercase;
  letter-spacing: 8px;
  color: <?=$ayar['renk']?>;
}

.preloader .loader {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  font-size: 0;
  z-index: 1;
  pointer-events: none;
}

.preloader .loader .row {
  height: 100%;
}

.preloader .loader .loader-section {
  padding: 0px;
}

.preloader .loader .loader-section .bg {
  background-color: #FFF;
  height: 100%;
  left: 0;
  width: 100%;
  -webkit-transition: all 800ms cubic-bezier(0.77, 0, 0.175, 1);
  transition: all 800ms cubic-bezier(0.77, 0, 0.175, 1);
}

.preloader .loader.dark_bg .loader-section .bg {
  background: #efc94c;
}

.preloader.loaded .animation-preloader {
  opacity: 0;
  -webkit-transition: 0.3s ease-out;
  transition: 0.3s ease-out;
}

.preloader.loaded .loader-section .bg {
  width: 0;
  -webkit-transition: 0.7s 0.3s allcubic-bezier(0.1, 0.1, 0.1, 1);
  transition: 0.7s 0.3s allcubic-bezier(0.1, 0.1, 0.1, 1);
}

@-webkit-keyframes spinner {
  to {
    -webkit-transform: rotateZ(360deg);
    transform: rotateZ(360deg);
  }
}

@keyframes spinner {
  to {
    -webkit-transform: rotateZ(360deg);
    transform: rotateZ(360deg);
  }
}

@-webkit-keyframes letters-loading {
  0%,
  75%,
  100% {
    opacity: 0;
    -webkit-transform: rotateY(-90deg);
    transform: rotateY(-90deg);
  }
  25%,
  50% {
    opacity: 1;
    -webkit-transform: rotateY(0deg);
    transform: rotateY(0deg);
  }
}

@keyframes letters-loading {
  0%,
  75%,
  100% {
    opacity: 0;
    -webkit-transform: rotateY(-90deg);
    transform: rotateY(-90deg);
  }
  25%,
  50% {
    opacity: 1;
    -webkit-transform: rotateY(0deg);
    transform: rotateY(0deg);
  }
}

/* ----------------------------------
    Template Section Styles
 ------------------------------------*/
header {
  width: 100%;
  z-index: 9999;
}

header.header-1 {
  position: absolute;
  top: 0;
  left: 0;
}

header.header-1 .logo {
  padding: 32px 0px;
}

header.header-1 .main-menu ul {
  line-height: 1;
}

header.header-1 .main-menu ul > li {
  display: inline-block;
  line-height: 1;
}

header.header-1 .main-menu ul > li > a {
  display: inline-block;
  font-size: 16px;
  text-transform: capitalize;
  line-height: 1;
  padding: 25px 20px;
  overflow: hidden;
}

header.header-1 .main-menu ul > li > a i {
  margin-left: 5px;
}

header.header-1 .main-menu ul > li:hover > a {
  color: #febc35;
}

header.header-1 .main-menu ul > li:hover > ul {
  opacity: 1;
  visibility: visible;
  -webkit-transform: translateY(0);
          transform: translateY(0);
}

header.header-1 .main-menu ul > li > ul {
  position: absolute;
  top: 100%;
  width: 230px;
  background-color: #febc35;
  left: 0;
  z-index: 999;
  -webkit-box-shadow: 0 13px 35px -12px rgba(35, 35, 35, 0.15);
          box-shadow: 0 13px 35px -12px rgba(35, 35, 35, 0.15);
  visibility: hidden;
  opacity: 0;
  -webkit-transform: translateY(40px);
          transform: translateY(40px);
  -webkit-transition: all .5s ease-in-out;
  transition: all .5s ease-in-out;
  padding: 10px 0px;
}

header.header-1 .main-menu ul > li > ul li {
  display: block;
}

header.header-1 .main-menu ul > li > ul li a {
  display: block;
  color: #000;
  padding: 12px 25px;
}

header.header-1 .main-menu ul > li > ul li a:hover {
  color: #fff;
}

header.header-1 .main-menu ul > li > ul ul {
  left: 100%;
  top: 0;
}

@media (max-width: 1199px) {
  header.header-1 .theme-btn {
    padding: 17px 32px;
    font-size: 12px;
  }
}

@media (max-width: 991px) {
  header.header-1 #hamburger {
    color: <?=$ayar['renk']?>;
  }
}

header .logo a {
  display: block;
}

header.header-2 {
  position: relative;
}

header.header-2 .main-menu ul {
  line-height: 1;
}

header.header-2 .main-menu ul > li {
  display: inline-block;
  line-height: 1;
}

header.header-2 .main-menu ul > li > a {
  display: inline-block;
  font-size: 16px;
  text-transform: capitalize;
  line-height: 1;
  padding: 40px 20px;
  overflow: hidden;
  color: #fff;
}

header.header-2 .main-menu ul > li > a i {
  margin-left: 5px;
}

header.header-2 .main-menu ul > li:hover > a {
  color: <?=$ayar['renk']?>;
}

header.header-2 .main-menu ul > li:hover > ul {
  opacity: 1;
  visibility: visible;
  -webkit-transform: translateY(0);
          transform: translateY(0);
}

header.header-2 .main-menu ul > li > ul {
  position: absolute;
  top: 100%;
  width: 230px;
  background-color: <?=$ayar['renk']?>;
  left: 0;
  z-index: 999;
  -webkit-box-shadow: 0 13px 35px -12px rgba(35, 35, 35, 0.15);
          box-shadow: 0 13px 35px -12px rgba(35, 35, 35, 0.15);
  visibility: hidden;
  opacity: 0;
  -webkit-transform: translateY(40px);
          transform: translateY(40px);
  -webkit-transition: all .5s ease-in-out;
  transition: all .5s ease-in-out;
  padding: 10px 0px;
}

header.header-2 .main-menu ul > li > ul li {
  display: block;
}

header.header-2 .main-menu ul > li > ul li a {
  display: block;
  color: #fff;
  padding: 12px 25px;
}

header.header-2 .main-menu ul > li > ul li a:hover {
  color: #fff;
}

header.header-2 .main-menu ul > li > ul ul {
  left: 100%;
  top: 0;
}

header.header-2 .top-header {
  background-color: rgba(8, 106, 215, 0.1);
  position: relative;
  z-index: 1;
  padding: 6px 50px;
}

@media (min-width: 1600px) {
  header.header-2 .top-header {
    padding: 6px 255px 6px 255px;
  }
}

@media (max-width: 1199px) {
  header.header-2 .top-header {
    padding: 6px 30px;
  }
}

@media (max-width: 991px) {
  header.header-2 .top-header {
    background: <?=$ayar['renk']?>;
    padding: 6px 15px;
  }
}

header.header-2 .top-header::before {
  position: absolute;
  content: "";
  height: 100%;
  background: <?=$ayar['renk']?>;
  width: 714px;
  -webkit-clip-path: polygon(0 0, 97% 0, 100% 100%, 0% 100%);
  clip-path: polygon(0 0, 97% 0, 100% 100%, 0% 100%);
  top: 0;
  left: 0;
}

@media (max-width: 991px) {
  header.header-2 .top-header::before {
    display: none;
  }
}

header.header-2 .top-header .header-cta ul {
  margin: 0;
  padding: 0;
}

header.header-2 .top-header .header-cta ul li {
  display: inline-block;
  padding-right: 25px;
  position: relative;
  margin-right: 25px;
}

header.header-2 .top-header .header-cta ul li::before {
  position: absolute;
  content: "";
  top: 50%;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  background: rgba(255, 255, 255, 0.3);
  width: 2px;
  height: 20px;
  right: 0;
}

header.header-2 .top-header .header-cta ul li:last-child::before {
  display: none;
}

header.header-2 .top-header .header-cta ul li a {
  display: inline-block;
  color: #fff;
  font-weight: 400;
  font-size: 16px;
}

header.header-2 .top-header .header-cta ul li a i {
  margin-right: 5px;
}

header.header-2 .top-header .header-right-cta {
  color: <?=$ayar['renk']?>;
}

@media (max-width: 991px) {
  header.header-2 .top-header .header-right-cta {
    color: #fff;
  }
}

header.header-2 .top-header .header-right-cta .social-profile a {
  color: #696969;
  margin-left: 15px;
  font-size: 15px;
}

header.header-2 .top-header .header-right-cta .social-profile a:hover {
  color: <?=$ayar['renk']?>;
}

@media (max-width: 991px) {
  header.header-2 .top-header .header-right-cta .social-profile a {
    color: #fff;
  }
}

@media (max-width: 375px) {
  header.header-2 .header-btn-cta {
    display: none;
  }
}

header.header-2 .main-header-wraper {
  background-color: #211e3b;
  position: relative;
  padding: 0px 50px;
}

@media (min-width: 1600px) {
  header.header-2 .main-header-wraper {
    padding: 0px 255px;
  }
}

@media (max-width: 1199px) {
  header.header-2 .main-header-wraper {
    padding: 15px 30px;
  }
}

@media (max-width: 991px) {
  header.header-2 .main-header-wraper {
    padding: 15px;
  }
}

@media (max-width: 1191px) {
  header.header-2 .main-header-wraper .theme-btn {
    padding: 15px 30px;
    font-size: 13px;
  }
}

@media (max-width: 500px) {
  header.header-2 .main-header-wraper .theme-btn {
    padding: 14px 25px;
    font-size: 12px;
  }
}

header.header-3 .top-header {
  background-color: #e6f0fb;
  padding: 14px 0px;
}

@media (max-width: 767px) {
  header.header-3 .top-header {
    padding: 10px 0px;
  }
}

@media (max-width: 767px) {
  header.header-3 .top-header .welcome-text {
    font-size: 13px;
  }
}

header.header-3 .top-header .welcome-text a {
  text-decoration: underline;
  color: <?=$ayar['renk']?>;
  margin-left: 5px;
}

@media (max-width: 767px) {
  header.header-3 .top-header .welcome-text a {
    font-size: 13px;
  }
}

header.header-3 .mobile-nav-bar {
  display: none;
}

@media (max-width: 1340px) {
  header.header-3 .mobile-nav-bar {
    display: block;
  }
}

header.header-3 #hamburger {
  display: block;
  color: <?=$ayar['renk']?>;
}

header.header-3 .menu-top-bar {
  position: relative;
  padding: 20px 0px 15px;
  overflow: hidden;
}

header.header-3 .side-toggle-menu {
  top: 0;
  right: 0;
  width: 8%;
  position: absolute;
  background-color: #211e3b;
  color: #fff;
  height: 100%;
  font-size: 32px;
  text-align: center;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

header.header-3 .side-toggle-menu i {
  position: absolute;
  top: 50%;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  left: 32%;
}

header.header-3 .side-toggle-menu:hover {
  background-color: <?=$ayar['renk']?>;
  color: #fff;
  cursor: pointer;
}

header.header-3 .contact-info-grid {
  display: -ms-grid;
  display: grid;
  -ms-grid-columns: 1fr 1fr 1fr;
      grid-template-columns: 1fr 1fr 1fr;
  grid-row: auto;
  width: 92%;
  padding-right: 30px;
}

header.header-3 .single-menu-box {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
  padding-left: 30px;
  position: relative;
}

@media (max-width: 1600px) {
  header.header-3 .single-menu-box {
    padding-left: 15px;
  }
}

@media (max-width: 1400px) {
  header.header-3 .single-menu-box {
    padding-left: 30px;
  }
}

header.header-3 .single-menu-box::before {
  position: absolute;
  width: 1px;
  height: 400%;
  top: 0;
  left: 0;
  content: "";
  background-color: #e8e8eb;
  -webkit-transform: translateY(-40%);
          transform: translateY(-40%);
}

header.header-3 .single-menu-box .icon {
  float: left;
  overflow: hidden;
  font-size: 42px;
  line-height: 1;
  color: <?=$ayar['renk']?>;
  margin-right: 20px;
}

@media (max-width: 1600px) {
  header.header-3 .single-menu-box .icon {
    font-size: 32px;
    margin-right: 10px;
  }
}

@media (max-width: 1400px) {
  header.header-3 .single-menu-box .icon {
    font-size: 32px;
    margin-right: 20px;
  }
}

header.header-3 .single-menu-box .content {
  overflow: hidden;
}

header.header-3 .single-menu-box .content h3 {
  line-height: 1;
}

header.header-3 .single-menu-box .content span {
  font-size: 16px;
  line-height: 1;
}

header.header-3 .middle-header-wraper {
  padding: 0px 70px;
}

@media (max-width: 1600px) {
  header.header-3 .middle-header-wraper {
    padding: 0px 30px;
  }
}

@media (max-width: 1400px) {
  header.header-3 .middle-header-wraper {
    padding: 0px 15px;
  }
}

@media (max-width: 1340px) {
  header.header-3 .middle-header-wraper {
    padding: 15px;
  }
}

@media (max-width: 767px) {
  header.header-3 .middle-header-wraper {
    padding: 15px 0;
  }
}

@media (max-width: 1340px) {
  header.header-3 .header-menu-wrap {
    display: none;
  }
}

header.header-3 .main-menu-wrapper {
  background-color: <?=$ayar['renk']?>;
  margin-bottom: -40px;
  z-index: 999;
  position: relative;
}

header.header-3 .main-menu ul {
  line-height: 1;
}

header.header-3 .main-menu ul > li {
  display: inline-block;
  line-height: 1;
}

header.header-3 .main-menu ul > li > a {
  display: inline-block;
  font-size: 16px;
  text-transform: capitalize;
  line-height: 1;
  padding: 30px;
  overflow: hidden;
  color: #fff;
}

header.header-3 .main-menu ul > li > a i {
  margin-left: 5px;
}

header.header-3 .main-menu ul > li:hover > a {
  color: #000;
}

header.header-3 .main-menu ul > li:hover > ul {
  opacity: 1;
  visibility: visible;
  -webkit-transform: translateY(0);
          transform: translateY(0);
}

header.header-3 .main-menu ul > li > ul {
  position: absolute;
  top: 100%;
  width: 230px;
  background-color: <?=$ayar['renk']?>;
  left: 0;
  z-index: 999;
  -webkit-box-shadow: 0 13px 35px -12px rgba(35, 35, 35, 0.15);
          box-shadow: 0 13px 35px -12px rgba(35, 35, 35, 0.15);
  visibility: hidden;
  opacity: 0;
  -webkit-transform: translateY(40px);
          transform: translateY(40px);
  -webkit-transition: all .5s ease-in-out;
  transition: all .5s ease-in-out;
  padding: 10px 0px;
}

header.header-3 .main-menu ul > li > ul li {
  display: block;
}

header.header-3 .main-menu ul > li > ul li a {
  display: block;
  color: #fff;
  padding: 12px 25px;
}

header.header-3 .main-menu ul > li > ul li a:hover {
  color: #000;
}

header.header-3 .main-menu ul > li > ul ul {
  left: 100%;
  top: 0;
}

@media (max-width: 1600px) {
  header.header-3 .theme-btn {
    padding: 18px 32px;
  }
}

@media (max-width: 1400px) {
  header.header-3 .theme-btn {
    padding: 16px 30px;
    font-size: 13px;
  }
}

@media (max-width: 1400px) {
  header.header-3 .theme-btn {
    padding: 16px 22px;
    font-size: 12px;
  }
}

header.header-4 {
  position: absolute;
  left: 0;
  width: 100%;
  top: 40px;
}

@media (max-width: 991px) {
  header.header-4 {
    top: 20px;
  }
}

@media (max-width: 1800px) {
  header.header-4 .container {
    border: 1px solid #37344e;
    padding: 15px 30px;
  }
}

header.header-4 .top-header {
  position: relative;
  z-index: 1;
}

@media (min-width: 1800px) {
  header.header-4 .top-header {
    border: 1px solid #37344e;
    margin: 0px 275px;
    padding: 10px 0px;
  }
}

header.header-4 .top-header .header-cta ul {
  margin: 0;
  padding: 0;
}

header.header-4 .top-header .header-cta ul li {
  display: inline-block;
  padding-right: 25px;
  position: relative;
  margin-right: 25px;
}

header.header-4 .top-header .header-cta ul li::before {
  position: absolute;
  content: "";
  top: 50%;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  background: rgba(255, 255, 255, 0.3);
  width: 2px;
  height: 20px;
  right: 0;
}

header.header-4 .top-header .header-cta ul li:last-child::before {
  display: none;
}

header.header-4 .top-header .header-cta ul li a {
  display: inline-block;
  color: #fff;
  font-weight: 400;
  font-size: 16px;
}

header.header-4 .top-header .header-cta ul li a i {
  margin-right: 5px;
}

header.header-4 .top-header .header-right-cta {
  color: <?=$ayar['renk']?>;
}

@media (max-width: 991px) {
  header.header-4 .top-header .header-right-cta {
    color: #fff;
  }
}

header.header-4 .top-header .header-right-cta .social-profile a {
  color: #696969;
  margin-left: 15px;
  font-size: 15px;
}

header.header-4 .top-header .header-right-cta .social-profile a:hover {
  color: <?=$ayar['renk']?>;
}

@media (max-width: 991px) {
  header.header-4 .top-header .header-right-cta .social-profile a {
    color: #fff;
  }
}

@media (max-width: 375px) {
  header.header-4 .header-btn-cta {
    display: none;
  }
}

@media (min-width: 1800px) {
  header.header-4 .main-header-wraper {
    border: 1px solid #37344e;
    margin: 0px 275px;
    border-top: 0px;
  }
}

@media (max-width: 1191px) {
  header.header-4 .main-header-wraper .theme-btn {
    padding: 15px 30px;
    font-size: 13px;
  }
}

@media (max-width: 500px) {
  header.header-4 .main-header-wraper .theme-btn {
    padding: 14px 25px;
    font-size: 12px;
  }
}

header.header-4 .main-menu ul {
  line-height: 1;
}

header.header-4 .main-menu ul > li {
  display: inline-block;
  line-height: 1;
}

header.header-4 .main-menu ul > li > a {
  display: inline-block;
  font-size: 16px;
  text-transform: capitalize;
  line-height: 1;
  padding: 40px 20px;
  overflow: hidden;
  color: #fff;
}

header.header-4 .main-menu ul > li > a i {
  margin-left: 5px;
}

header.header-4 .main-menu ul > li:hover > a {
  color: <?=$ayar['renk']?>;
}

header.header-4 .main-menu ul > li:hover > ul {
  opacity: 1;
  visibility: visible;
  -webkit-transform: translateY(0);
          transform: translateY(0);
}

header.header-4 .main-menu ul > li > ul {
  position: absolute;
  top: 100%;
  width: 230px;
  background-color: <?=$ayar['renk']?>;
  left: 0;
  z-index: 999;
  -webkit-box-shadow: 0 13px 35px -12px rgba(35, 35, 35, 0.15);
          box-shadow: 0 13px 35px -12px rgba(35, 35, 35, 0.15);
  visibility: hidden;
  opacity: 0;
  -webkit-transform: translateY(40px);
          transform: translateY(40px);
  -webkit-transition: all .5s ease-in-out;
  transition: all .5s ease-in-out;
  padding: 10px 0px;
}

header.header-4 .main-menu ul > li > ul li {
  display: block;
}

header.header-4 .main-menu ul > li > ul li a {
  display: block;
  color: #fff;
  padding: 12px 25px;
}

header.header-4 .main-menu ul > li > ul li a:hover {
  color: #fff;
}

header.header-4 .main-menu ul > li > ul ul {
  left: 100%;
  top: 0;
}

header.header-4 .lan-select select {
  color: #fff;
  line-height: 1.2;
}

header.header-4 .lan-select select option {
  color: #211e3b;
}

.lan-select {
  font-weight: 500;
  float: right;
}

.lan-select select {
  border: 0px;
  background: transparent;
  color: #211e3b;
  cursor: pointer;
  font-size: 16px;
}

@media (max-width: 991px) {
  .lan-select select {
    color: #fff;
  }
}

.lan-select select option {
  color: #211e3b;
  border: 0px;
}

.top-bar {
  padding: 0px 25px;
  background: #211e3b;
  position: relative;
  overflow: hidden;
}

.top-bar.style-3 {
  padding: 13px 0px;
  display: block;
}

@media (min-width: 1600px) {
  .top-bar.style-3 .container {
    max-width: 1445px;
  }
}

.top-bar .contact-data ul li {
  font-size: 14px;
  line-height: 1;
  color: #8f9aba;
  display: inline-block;
  margin-right: 35px;
}

.top-bar .contact-data ul li i {
  color: #fff;
  margin-right: 5px;
}

.top-bar .social_link a {
  color: #8d98ba;
  display: inline-block;
  margin-right: 20px;
  font-size: 14px;
  line-height: 1;
}

.top-bar .social_link a:hover {
  color: #fff;
}

.top-bar .lan-select-menu {
  padding: 16px 30px;
  display: inline-block;
  position: relative;
}

.top-bar .lan-select-menu::before {
  position: absolute;
  width: 200%;
  height: 100%;
  content: "";
  background: #000b2c;
  top: 0;
  left: 0;
}

.top-bar .lan-select-menu form {
  font-size: 14px;
}

.top-bar .lan-select-menu form select {
  color: #fff;
  border: 0px;
  background: transparent;
}

.top-bar .lan-select-menu form select option {
  color: #FFF;
  background: #000b2c;
  border: 0px;
}

.page-banner-wrap {
  background-color: #211e3b;
  padding-bottom: 70px;
  padding-top: 70px;
  position: relative;
  z-index: 1;
  background-position: 450px;
}

@media (max-width: 1400px) {
  .page-banner-wrap {
    padding-top: 70px;
    padding-bottom: 70px;
    background-position: 0;
  }
}

@media (max-width: 767px) {
  .page-banner-wrap {
    padding-top: 60px;
    padding-bottom: 40px;
  }
}

.page-banner-wrap::before {
  position: absolute;
  left: 0;
  content: "";
  top: 0;
  background: #211e3b;
  width: 100%;
  height: 100%;
  z-index: -1;
  opacity: .8;
}

.page-banner-wrap .banner-text {
  position: absolute;
  top: 70%;
  -webkit-transform: translateY(-50%) rotate(-90deg) translateX(23%);
          transform: translateY(-50%) rotate(-90deg) translateX(23%);
  -webkit-text-fill-color: transparent;
  -webkit-text-stroke-width: 4px;
  -webkit-text-stroke-color: rgba(255, 255, 255, 0.2);
  font-size: 120px;
  font-family: "Circular Std", sans-serif;
  font-weight: 900;
  letter-spacing: -0.03em;
  left: 110px;
  z-index: 2;
  opacity: 0.15;
  text-transform: uppercase;
}

@media (max-width: 1199px) {
  .page-banner-wrap .banner-text {
    display: none;
  }
}

.page-banner-wrap h1 {
  font-size: 80px;
  text-transform: capitalize;
}

@media (max-width: 1199px) {
  .page-banner-wrap h1 {
    font-size: 60px;
  }
}

@media (max-width: 767px) {
  .page-banner-wrap h1 {
    font-size: 40px;
  }
}

.page-banner-wrap .breadcrumb {
  margin-top: 30px;
  background: transparent;
  padding: 0;
}

@media (max-width: 1199px) {
  .page-banner-wrap .breadcrumb {
    margin-top: 10px;
  }
}

@media (max-width: 767px) {
  .page-banner-wrap .breadcrumb {
    float: left;
  }
}

.page-banner-wrap .breadcrumb li {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
  color: #fff;
  font-weight: 400;
  font-size: 20px;
  line-height: 1;
  text-transform: capitalize;
}

@media (max-width: 767px) {
  .page-banner-wrap .breadcrumb li {
    font-size: 14px !important;
  }
}

.page-banner-wrap .breadcrumb li a {
  color: #fff;
  font-size: 20px;
  font-weight: 400 !important;
  line-height: 1;
}

@media (max-width: 767px) {
  .page-banner-wrap .breadcrumb li a {
    font-size: 14px;
  }
}

.page-banner-wrap .breadcrumb li a:hover {
  color: <?=$ayar['renk']?>;
}

.page-banner-wrap .breadcrumb li + li::before {
  color: #c5c2c2;
  content: "\f105";
  font-family: "Font Awesome 5 Pro";
  font-weight: 400;
}

.mobile-nav {
  position: fixed;
  right: -380px;
  top: 0;
  width: 320px;
  height: 100vh;
  scroll-behavior: smooth;
  overflow-y: scroll;
  -webkit-transition: right .5s ease-in;
  transition: right .5s ease-in;
  background-color: <?=$ayar['renk']?>;
  padding: 20px;
  z-index: 9999;
  -webkit-box-shadow: 0 13px 35px -12px rgba(35, 35, 35, 0.15);
          box-shadow: 0 13px 35px -12px rgba(35, 35, 35, 0.15);
  /* Vertical Menu Style */
}

.mobile-nav.show {
  right: 0px;
}

.mobile-nav .close-nav {
  border: 0;
  background: transparent;
  color: #fff;
  border-radius: 30px;
  font-size: 20px;
  position: absolute;
  left: 20px;
  top: 10px;
}

.mobile-nav .sidebar-nav {
  margin-top: 30px;
}

.mobile-nav .sidebar-nav ul {
  margin: 0;
  padding: 0;
  list-style: none;
  background-color: transparent;
}

.mobile-nav .sidebar-nav .metismenu {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-orient: vertical;
  -webkit-box-direction: normal;
      -ms-flex-direction: column;
          flex-direction: column;
}

.mobile-nav .sidebar-nav .metismenu > li {
  position: relative;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-orient: vertical;
  -webkit-box-direction: normal;
      -ms-flex-direction: column;
          flex-direction: column;
}

.mobile-nav .sidebar-nav .metismenu a {
  position: relative;
  display: block;
  padding: 10px 15px;
  -webkit-transition: all .3s ease-out;
  transition: all .3s ease-out;
  text-decoration: none;
  color: #fff;
  outline-width: 0;
  text-transform: capitalize;
  border-bottom: 1px solid rgba(0, 0, 0, 0.05);
}

.mobile-nav .sidebar-nav .metismenu ul a {
  padding: 10px 15px 10px 35px;
  position: relative;
}

.mobile-nav .sidebar-nav .metismenu ul a:hover {
  padding-left: 40px;
}

.mobile-nav .sidebar-nav .metismenu ul a:hover::before {
  background-color: #fff;
}

.mobile-nav .sidebar-nav .metismenu ul a::before {
  position: absolute;
  left: 15px;
  width: 10px;
  height: 10px;
  border-radius: 50%;
  border: 2px solid #fff;
  content: "";
  top: 50%;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
}

.mobile-nav .sidebar-nav .metismenu ul ul {
  list-style-type: circle !important;
}

.mobile-nav .sidebar-nav .metismenu ul ul a {
  padding: 10px 15px 10px 45px;
}

.mobile-nav .sidebar-nav .metismenu a:hover,
.mobile-nav .sidebar-nav .metismenu a:focus,
.mobile-nav .sidebar-nav .metismenu a:active {
  text-decoration: none;
  color: #f8f9fa;
  background: <?=$ayar['renk']?>;
}

#hamburger {
  color: #fff;
  font-size: 36px;
  line-height: 1;
  text-align: right;
  display: none;
}

#hamburger i {
  cursor: pointer;
}

@media (max-width: 1199px) {
  #hamburger {
    display: block;
  }
}

.action-bar {
  margin-top: 30px;
  padding-left: 20px;
}

.action-bar a {
  color: #fff;
  display: block;
  margin-top: 12px;
}

.action-bar a i {
  margin-right: 10px;
}

.action-bar a.theme-btn {
  text-align: center;
}

/* ---------------------------------
    Offset Canvas Menu Style 
------------------------------------*/
.offset-menu {
  position: fixed;
  height: 100vh;
  top: 0;
  z-index: 9999999;
  opacity: 0;
  visibility: hidden;
  right: -30%;
  -webkit-transition: all .5s ease-in-out;
  transition: all .5s ease-in-out;
  background-color: #211e3b;
  -webkit-box-shadow: 0 13px 35px -12px rgba(35, 35, 35, 0.15);
          box-shadow: 0 13px 35px -12px rgba(35, 35, 35, 0.15);
}

.offset-menu.show {
  opacity: 1;
  visibility: visible;
  right: 0;
}

.offset-menu .offset-menu-wrapper {
  width: 360px;
  padding: 80px 30px;
}

.offset-menu .theme-btn {
  padding: 20px 45px;
  font-weight: 500;
  margin-top: 40px;
}

.offset-menu .offset-menu-section {
  margin-top: 40px;
}

.offset-menu .offset-menu-section h3, .offset-menu .offset-menu-section h4, .offset-menu .offset-menu-section h5 {
  line-height: 1;
  margin-bottom: 20px;
}

.offset-menu .offset-menu-section a {
  margin-bottom: 10px;
}

.offset-menu .offset-menu-section ul li {
  margin-bottom: 5px;
}

.offset-menu .offset-menu-section ul li span {
  margin-right: 10px;
}

.offset-menu #offset-menu-close-btn {
  position: fixed;
  right: 30px;
  font-size: 28px;
  -webkit-transform: rotate(45deg);
          transform: rotate(45deg);
  color: #fff;
  cursor: pointer;
  -webkit-transition: all .2s ease-in-out;
  transition: all .2s ease-in-out;
  z-index: 9;
  top: 20px;
}

.offset-menu #offset-menu-close-btn:hover {
  color: #ff5e14;
}

.offset-menu .offset-menu-footer {
  margin-top: 35px;
}

.offset-menu .offset-menu-social-icon a {
  font-size: 16px;
  background: #211e3b;
  display: inline-block;
  border-radius: 50%;
  width: 40px;
  height: 40px;
  line-height: 40px;
  text-align: center;
  margin-right: 5px;
}

.offset-menu .offset-menu-social-icon a:hover {
  background: <?=$ayar['renk']?>;
}

.offset-menu img {
  display: inline-block;
  background: #fff;
  padding: 10px 20px;
}

/* ----------------------------------
   Hero Section - Styles
 ------------------------------------ */
.hero-1 .single-slide {
  padding: 330px 0px 225px;
  z-index: 1;
  position: relative;
  overflow: hidden;
}

@media (max-width: 1199px) {
  .hero-1 .single-slide {
    padding: 230px 0px 175px;
  }
}

@media (max-width: 991px) {
  .hero-1 .single-slide {
    padding: 180px 0px 120px;
  }
}

@media (max-width: 767px) {
  .hero-1 .single-slide {
    padding: 150px 0px 100px;
  }
}

.hero-1 .single-slide::before {
  position: absolute;
  left: 0;
  top: 0;
  background-image: url("../img/slide_bg_circle.png");
  width: 60%;
  height: 100%;
  content: "";
  z-index: -1;
  opacity: .5;
  background-repeat: no-repeat;
}

@media (max-width: 1600px) {
  .hero-1 .single-slide::before {
    width: 100%;
  }
}

.hero-1 .single-slide .hero-contents {
  position: relative;
  z-index: 2;
}

.hero-1 .single-slide .hero-contents h1 {
  font-weight: 900;
}

@media (max-width: 1199px) {
  .hero-1 .single-slide .hero-contents h1 {
    font-size: 100px;
  }
}

@media (max-width: 991px) {
  .hero-1 .single-slide .hero-contents h1 {
    font-size: 80px;
  }
}

@media (max-width: 767px) {
  .hero-1 .single-slide .hero-contents h1 {
    font-size: 60px;
  }
}

.hero-1 .single-slide .hero-contents h2 {
  font-size: 100px;
  line-height: 1;
  font-weight: 900;
  margin-bottom: 20px;
}

@media (max-width: 1199px) {
  .hero-1 .single-slide .hero-contents h2 {
    font-size: 80px;
  }
}

@media (max-width: 991px) {
  .hero-1 .single-slide .hero-contents h2 {
    font-size: 70px;
  }
}

@media (max-width: 767px) {
  .hero-1 .single-slide .hero-contents h2 {
    font-size: 50px;
  }
}

.hero-1 .single-slide .hero-contents p {
  color: #211e3b;
  font-weight: 500;
  font-size: 24px;
  margin-top: 20px;
}

@media (max-width: 767px) {
  .hero-1 .single-slide .hero-contents p {
    font-size: 20px;
  }
}

.hero-1 .single-slide .hero-contents a {
  margin-top: 35px;
  margin-right: 20px;
}

@media (max-width: 767px) {
  .hero-1 .single-slide .hero-contents a {
    margin-top: 20px;
  }
}

.hero-1 .single-slide .slide-top-img {
  width: 771px;
  height: 788px;
  position: absolute;
  z-index: -1;
  background-color: #eee;
  right: 0;
  top: 0;
  content: "";
  -webkit-clip-path: polygon(25% 0, 100% 0%, 101% 70%, 66% 80%, 0% 17%);
          clip-path: polygon(25% 0, 100% 0%, 101% 70%, 66% 80%, 0% 17%);
  background-position: -125px;
}

@media (max-width: 1400px) {
  .hero-1 .single-slide .slide-top-img {
    width: 634px;
    height: 652px;
    right: -83px;
    background-position: -90px;
  }
}

.hero-1 .single-slide .slide-bottom-img {
  width: 972px;
  height: 486px;
  position: absolute;
  z-index: -1;
  background-color: #eee;
  right: 30px;
  bottom: 0;
  content: "";
  -webkit-clip-path: polygon(50% 0%, 100% 100%, 0% 100%);
          clip-path: polygon(50% 0%, 100% 100%, 0% 100%);
}

@media (max-width: 1400px) {
  .hero-1 .single-slide .slide-bottom-img {
    width: 672px;
    height: 386px;
    right: 0;
  }
}

.hero-1 .single-slide .bg-overlay::before {
  background: #211e3b;
  opacity: .1;
}

.hero-2 {
  position: relative;
  padding-left: 270px;
  background-color: #211e3b;
}

@media (max-width: 1600px) {
  .hero-2 {
    padding-left: 0;
  }
}

.hero-2 .hero-text {
  position: absolute;
  top: 70%;
  -webkit-transform: translateY(-50%) rotate(-90deg) translateX(23%);
          transform: translateY(-50%) rotate(-90deg) translateX(23%);
  -webkit-text-fill-color: transparent;
  -webkit-text-stroke-width: 4px;
  -webkit-text-stroke-color: rgba(255, 255, 255, 0.2);
  font-size: 215px;
  font-family: "Circular Std";
  font-weight: 900;
  letter-spacing: -0.03em;
  left: -15px;
  z-index: 2;
  opacity: 0.15;
}

@media (max-width: 1600px) {
  .hero-2 .hero-text {
    display: none;
  }
}

.hero-2 .single-slide {
  padding: 250px 0px;
  z-index: 1;
  position: relative;
  padding-left: 90px;
}

@media (max-width: 1600px) {
  .hero-2 .single-slide {
    padding: 180px 0px;
    padding-left: 80px;
  }
}

@media (max-width: 1199px) {
  .hero-2 .single-slide {
    padding-left: 30px;
  }
}

@media (max-width: 991px) {
  .hero-2 .single-slide {
    padding: 160px 0px;
  }
}

@media (max-width: 767px) {
  .hero-2 .single-slide {
    padding: 130px 0px;
  }
}

@media (max-width: 500px) {
  .hero-2 .single-slide {
    padding: 100px 0px;
  }
}

.hero-2 .single-slide::before, .hero-2 .single-slide::after {
  position: absolute;
  content: "";
  width: 100%;
  height: 100%;
  left: 0;
  top: 0;
  background-image: -webkit-gradient(linear, left top, right top, from(#211e3b), to(rgba(33, 30, 59, 0)));
  background-image: linear-gradient(90deg, #211e3b 0%, rgba(33, 30, 59, 0) 100%);
  background-image: -ms-linear-gradient(90deg, #211e3b 0%, rgba(33, 30, 59, 0) 100%);
  z-index: -1;
}

.hero-2 .single-slide .hero-contents {
  position: relative;
}

.hero-2 .single-slide .hero-contents h1 {
  color: #fff;
  font-size: 90px;
  font-weight: 900;
  line-height: 110%;
  margin-top: -10px;
  text-transform: capitalize;
}

@media (max-width: 1600px) {
  .hero-2 .single-slide .hero-contents h1 {
    font-size: 70px;
  }
}

@media (max-width: 767px) {
  .hero-2 .single-slide .hero-contents h1 {
    font-size: 50px;
  }
}

@media (max-width: 500px) {
  .hero-2 .single-slide .hero-contents h1 {
    font-size: 42px;
  }
}

@media (max-width: 375px) {
  .hero-2 .single-slide .hero-contents h1 {
    font-size: 40px;
  }
}

.hero-2 .single-slide .hero-contents p {
  color: #fff;
  font-weight: 500;
  font-size: 24px;
  margin-top: 20px;
}

@media (max-width: 767px) {
  .hero-2 .single-slide .hero-contents p {
    font-size: 22px;
  }
}

.hero-2 .single-slide .hero-contents a {
  margin-top: 35px;
  margin-right: 20px;
  color: #fff;
}

@media (max-width: 375px) {
  .hero-2 .single-slide .hero-contents a {
    margin-top: 20px;
    margin-right: 0;
  }
}

.hero-2 .owl-theme .owl-dots {
  display: none;
  margin-top: 0;
  position: absolute;
  right: 30px;
  top: 50%;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
}

.hero-2 .owl-theme .owl-dots .owl-dot {
  display: block;
  width: 10px;
  height: 10px;
  border-radius: 50px;
  text-align: center;
  padding: 15px;
  position: relative;
}

.hero-2 .owl-theme .owl-dots .owl-dot span {
  background-color: #fff;
  display: block;
  margin: 0;
  position: absolute;
  left: 50%;
  top: 50%;
}

.hero-2 .owl-theme .owl-dots .owl-dot::before {
  position: absolute;
  left: 0;
  top: 0;
  background: transparent;
  border-width: 3px;
  border-color: #fff;
  border-style: solid;
  border-radius: 50%;
  width: 24px;
  height: 24px;
  content: "";
}

.hero-3 {
  position: relative;
}

.hero-3 .single-slide {
  padding: 200px 0px 165px;
  z-index: 1;
  position: relative;
}

@media (max-width: 1300px) {
  .hero-3 .single-slide {
    padding: 150px 0px 125px;
  }
}

@media (max-width: 991px) {
  .hero-3 .single-slide {
    padding: 100px 0px;
  }
}

.hero-3 .single-slide::before {
  position: absolute;
  content: "";
  width: 100%;
  height: 100%;
  left: 0;
  top: 0;
  opacity: .85;
  background-color: #060404;
}

.hero-3 .single-slide .hero-contents {
  position: relative;
}

.hero-3 .single-slide .hero-contents h1 {
  color: #fff;
  font-size: 130px;
  font-weight: 900;
  line-height: 110%;
  margin-top: -10px;
}

@media (max-width: 991px) {
  .hero-3 .single-slide .hero-contents h1 {
    font-size: 90px;
  }
}

@media (max-width: 767px) {
  .hero-3 .single-slide .hero-contents h1 {
    font-size: 80px;
  }
}

.hero-3 .single-slide .hero-contents p {
  color: #fff;
  font-size: 22px;
  font-weight: 500;
  margin-bottom: 30px;
  position: relative;
  padding-left: 40px;
  display: inline-block;
}

@media (max-width: 991px) {
  .hero-3 .single-slide .hero-contents p {
    font-size: 18px;
  }
}

@media (max-width: 767px) {
  .hero-3 .single-slide .hero-contents p::before, .hero-3 .single-slide .hero-contents p::after {
    display: none !important;
  }
}

.hero-3 .single-slide .hero-contents p::before {
  border-radius: 50%;
  width: 9px;
  height: 9px;
  background-color: #fff;
  content: "";
  left: 6px;
  top: 50%;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  position: absolute;
  display: inline-block;
}

.hero-3 .single-slide .hero-contents p::after {
  border-radius: 50%;
  width: 21px;
  height: 21px;
  background-color: transparent;
  content: "";
  left: 0;
  top: 50%;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  position: absolute;
  display: inline-block;
  border: 2px solid #fff;
}

.hero-3 .single-slide .hero-contents a {
  margin-top: 35px;
  margin-right: 20px;
  color: #fff;
}

@media (max-width: 991px) {
  .hero-3 .single-slide .hero-contents a {
    margin-top: 25px;
    margin-right: 15px;
  }
}

@media (max-width: 767px) {
  .hero-3 .single-slide .hero-contents a {
    margin-right: 5px;
  }
}

.hero-3 .owl-theme .owl-dots {
  margin-top: 0;
  position: absolute;
  right: 30px;
  top: 50%;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  display: inline-block;
}

.hero-3 .owl-theme .owl-dots .owl-dot {
  display: block;
  width: 100%;
  text-align: center;
}

.hero-3 .owl-theme .owl-dots .owl-dot span {
  width: 10px;
  height: 10px;
  border-radius: 50px;
  background-color: #fff;
  position: relative;
  display: block;
  margin: 0;
}

.hero-3 .owl-theme .owl-dots .owl-dot span::before {
  position: absolute;
  left: 0;
  top: 0;
  background: transparent;
  border-width: 3px;
  border-color: #fff;
  border-style: solid;
  border-radius: 50%;
  width: 24px;
  height: 24px;
  content: "";
}

.hero-4 {
  position: relative;
}

.hero-4 .single-slide {
  padding: 255px 0px 110px;
  z-index: 1;
  position: relative;
  background-color: #211e3b;
  overflow: hidden;
}

.hero-4 .single-slide::before {
  border-radius: 50%;
  background-image: -webkit-gradient(linear, left top, right top, from(rgba(47, 43, 81, 0.94902)), color-stop(67%, rgba(38, 34, 66, 0.55)), to(rgba(33, 30, 59, 0.14902)));
  background-image: linear-gradient(90deg, rgba(47, 43, 81, 0.94902) 0%, rgba(38, 34, 66, 0.55) 67%, rgba(33, 30, 59, 0.14902) 100%);
  position: absolute;
  left: 272px;
  top: 189px;
  width: 477px;
  height: 477px;
  content: "";
  z-index: -1;
}

@media (max-width: 1199px) {
  .hero-4 .single-slide::before {
    left: 50px;
    top: 80px;
  }
}

@media (max-width: 991px) {
  .hero-4 .single-slide::before {
    left: 20px;
    top: 80px;
  }
}

@media (max-width: 991px) {
  .hero-4 .single-slide {
    padding: 150px 0px 100px;
  }
}

@media (max-width: 767px) {
  .hero-4 .single-slide {
    padding: 120px 0px 100px;
  }
}

.hero-4 .single-slide .hero-contents {
  position: relative;
}

.hero-4 .single-slide .hero-contents::before {
  width: 85px;
  height: 85px;
  content: "";
  left: -150px;
  top: -100px;
  position: absolute;
  display: inline-block;
  background-image: url("../img/home4/star.png");
  background-repeat: no-repeat;
}

@media (max-width: 991px) {
  .hero-4 .single-slide .hero-contents::before {
    left: 90%;
    top: 20px;
  }
}

.hero-4 .single-slide .hero-contents h1 {
  color: #fff;
  font-size: 75px;
  font-weight: 900;
  line-height: 105%;
  margin-top: 20px;
  margin-bottom: 20px;
}

@media (max-width: 1199px) {
  .hero-4 .single-slide .hero-contents h1 {
    font-size: 60px;
  }
}

@media (max-width: 767px) {
  .hero-4 .single-slide .hero-contents h1 {
    font-size: 50px;
  }
}

.hero-4 .single-slide .hero-contents span {
  position: relative;
  color: #fff;
  padding-left: 60px;
  text-transform: uppercase;
}

.hero-4 .single-slide .hero-contents span::before {
  width: 40px;
  height: 2px;
  background-color: #fff;
  content: "";
  left: 0;
  top: 50%;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  position: absolute;
  display: inline-block;
}

.hero-4 .single-slide .hero-contents p {
  color: #fff;
  position: relative;
  display: inline-block;
}

@media (max-width: 991px) {
  .hero-4 .single-slide .hero-contents p {
    font-size: 18px;
  }
}

.hero-4 .single-slide .hero-contents a {
  margin-top: 35px;
  margin-right: 20px;
  color: #fff;
}

@media (max-width: 991px) {
  .hero-4 .single-slide .hero-contents a {
    margin-top: 25px;
    margin-right: 15px;
  }
}

@media (max-width: 767px) {
  .hero-4 .single-slide .hero-contents a {
    margin-right: 5px;
  }
}

.hero-4 .single-slide .hero-banner {
  position: relative;
}

.hero-4 .single-slide .hero-banner .dot {
  position: absolute;
  width: 145px;
  height: 146px;
  content: "";
  right: -80px;
  top: -80px;
  z-index: -1;
  background-image: url("../img/home4/dot4.png");
  background-repeat: no-repeat;
}

.hero-4 .single-slide .hero-banner::before {
  border-width: 1px;
  border-color: white;
  border-style: solid;
  opacity: 0.102;
  position: absolute;
  width: 100%;
  height: 100%;
  content: "";
  right: -20px;
  bottom: -20px;
  z-index: -1;
  border-top-left-radius: 50%;
}

.hero-4 .single-slide .hero-banner::after {
  border-width: 1px;
  border-color: white;
  border-style: solid;
  border-radius: 50%;
  opacity: 0.102;
  position: absolute;
  width: 249px;
  height: 249px;
  content: "";
  right: -120px;
  bottom: -80px;
  z-index: -1;
}

.section-title {
  position: relative;
  z-index: 1;
}

.section-title span {
  position: absolute;
  font-weight: 900;
  font-size: 120px;
  line-height: 1;
  color: #211e3b;
  position: absolute;
  left: 50%;
  -webkit-transform: translateX(-50%);
          transform: translateX(-50%);
  opacity: .05;
  z-index: -1;
  top: -40px;
  text-transform: uppercase;
  margin: 0px auto;
}

@media (max-width: 991px) {
  .section-title span {
    font-size: 90px;
    top: -30px;
  }
}

@media (max-width: 767px) {
  .section-title span {
    font-size: 80px;
    top: -20px;
  }
}

@media (max-width: 500px) {
  .section-title span {
    font-size: 60px;
  }
}

.section-title p {
  color: <?=$ayar['renk']?>;
  margin-bottom: 15px;
  font-weight: 700;
  font-size: 15px;
  line-height: 1;
  text-transform: uppercase;
}

.section-title h1 {
  line-height: 50px;
  font-weight: 900;
  text-transform: capitalize;
}

.section-title-2 {
  position: relative;
  z-index: 2;
  margin-bottom: 40px;
}

.section-title-2 span {
  font-size: 180px;
  line-height: 1;
  color: rgba(0, 22, 89, 0);
  font-weight: 600;
  -webkit-text-stroke: 1px #efefef;
  position: absolute;
  top: -38%;
  left: 50%;
  -webkit-transform: translateX(-50%);
          transform: translateX(-50%);
  opacity: .9;
  z-index: -1;
}

.section-title-2 p {
  color: #ff5e14;
}

.section-title-2 h1 {
  color: #211e3b;
}

.section-title-2 .icon {
  border-radius: 50%;
  background-color: #fff;
  -webkit-box-shadow: 0px 30px 60px 0px rgba(0, 0, 0, 0.08);
          box-shadow: 0px 30px 60px 0px rgba(0, 0, 0, 0.08);
  width: 120px;
  height: 120px;
  line-height: 120px;
  display: inline-block;
  margin: 0 auto;
  text-align: center;
  position: relative;
  margin-bottom: 50px;
}

.section-title-2 .icon::before {
  border-style: solid;
  border-width: 4px;
  border-radius: 50%;
  width: 180px;
  height: 180px;
  border-color: #eaeaea;
  position: absolute;
  content: "";
  top: 50%;
  left: 50%;
  -webkit-transform: translate(-50%, -50%);
          transform: translate(-50%, -50%);
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
  z-index: -1;
}

.section-padding {
  padding: 130px 0px;
}

@media (max-width: 991px) {
  .section-padding {
    padding: 100px 0px;
  }
}

@media (max-width: 767px) {
  .section-padding {
    padding: 80px 0px;
  }
}

.section-padding-two {
  padding: 140px 0px;
}

@media (max-width: 1400px) {
  .section-padding-two {
    padding: 120px 0px;
  }
}

@media (max-width: 991px) {
  .section-padding-two {
    padding: 100px 0px;

  }
}

@media (max-width: 767px) {
  .section-padding-two {
    padding: 80px 0px;
  }
}

.section-bg {
  background-color: #211e3b;
}

.section-bg-2 {
  background-color: #eef4fc;
}

.theme-bg {
  background-color: <?=$ayar['renk']?>;
}

/* ----------------------------------
	About Us Section Styles
 ------------------------------------ */
.about-us-img {
  border-radius: 10px;
  background-color: #eee;
  height: 475px;
  position: relative;
  z-index: 1;
}

@media (max-width: 767px) {
  .about-us-img {
    height: 300px;
  }
}

.dot-circle {
  position: absolute;
  left: 45px;
  top: 0;
  background-image: url("../img/dot-circle.png");
  width: 200px;
  height: 200px;
  content: "";
  -webkit-transform: translate(-50%, -50%);
          transform: translate(-50%, -50%);
  z-index: -1;
}

.triangle-bottom-right {
  border-bottom: 200px solid <?=$ayar['renk']?>;
  border-left: 200px solid transparent;
  border-radius: 0px 0px 0px 0px;
  position: absolute;
  right: 0;
  bottom: -15px;
  content: "";
  width: 0;
  height: 0;
  z-index: -1;
}

.about-right-img {
  position: relative;
}

.about-right-img .triangle-bottom-right {
  margin-right: -15px;
}

.about-icon-box {
  padding: 20px 40px;
  border-radius: 7px;
  border: 2px solid #eef4fc;
  margin-top: 40px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.about-icon-box.style-2 {
  padding: 0;
  border: 0;
  padding-right: 40px;
  margin-top: 30px;
}

.about-icon-box.style-2 .icon {
  background-color: #e6f0fb;
  border-radius: 7px;
  width: 60px;
  height: 60px;
  line-height: 60px;
  text-align: center;
  display: inline-block;
  font-size: 32px;
}

.about-icon-box.style-2 h3 {
  margin-top: -3px;
}

.about-icon-box.style-2 p {
  margin-top: 5px;
}

.about-icon-box:hover {
  border-color: <?=$ayar['renk']?>;
}

.about-icon-box .icon {
  font-size: 40px;
  line-height: 1;
  color: <?=$ayar['renk']?>;
  float: left;
  overflow: hidden;
  margin-right: 25px;
}

.about-icon-box .content {
  overflow: auto;
}

.about-thum {
  position: relative;
}

.about-thum::before, .about-thum::after {
  position: absolute;
  top: 50%;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  content: "";
  border-radius: 50%;
  right: 0;
  left: 0;
  margin: 0 auto;
  z-index: -1;
}

.about-thum::before {
  width: 359px;
  height: 359px;
  background-color: <?=$ayar['renk']?>;
}

@media (max-width: 767px) {
  .about-thum::before {
    display: none;
  }
}

.about-thum::after {
  width: 415px;
  height: 415px;
  background-color: rgba(8, 106, 215, 0.1);
}

@media (max-width: 767px) {
  .about-thum::after {
    display: none;
  }
}

.about-thum .item img {
  border-radius: 10px;
}

.about-thum .bottom-image {
  text-align: left;
  margin-top: -53px;
}

.about-check-list {
  margin-top: 40px;
}

@media (max-width: 375px) {
  .about-check-list {
    display: block !important;
  }
}

.about-check-list .banner {
  border-radius: 7px;
  background-color: #bfbfbf;
  width: 200px;
  height: 180px;
  position: relative;
  margin-right: 30px;
}

@media (max-width: 991px) {
  .checked-list {
    margin-left: 30px;
  }
}

@media (max-width: 767px) {
  .checked-list {
    margin-left: 0;
  }
}

.checked-list li {
  color: #211e3b;
  margin-top: 8px;
  padding-left: 40px;
  font-weight: 700;
}

.checked-list li::before {
  position: absolute;
  top: 0;
  left: 0;
  content: "\f058";
  font-family: "Font Awesome 5 Pro";
  font-weight: 700;
  font-size: 25px;
  color: <?=$ayar['renk']?>;
}

.brand-grid {
  display: -ms-grid;
  display: grid;
  -ms-grid-columns: 1fr 1fr 1fr 1fr 1fr;
      grid-template-columns: 1fr 1fr 1fr 1fr 1fr;
  -ms-grid-rows: auto;
      grid-template-rows: auto;
  margin-top: 60px;
}

.brand-grid .single-brand-logo {
  border: 1px solid #eee;
  padding: 50px;
  text-align: center;
}

.circle-shape {
  position: absolute;
  left: -180px;
  top: 25px;

  z-index: -1;
}

.circle-shape.style-2 {
  left: auto;
  right: -280px;
}

.icon-box-item {
  padding: 40px 30px 30px;
  border: 1px solid #e6f0fb;
  border-radius: 5px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
  margin-top: 30px;
}

.icon-box-item:hover {
  background-color: #e6f0fb;
}

.icon-box-item .icon {
  font-size: 60px;
  line-height: 1;
  color: <?=$ayar['renk']?>;
  margin-bottom: 10px;
}

.icon-box-item h4 {
  font-size: 22px;
}

.clip-path img {
  -webkit-clip-path: polygon(24% 0, 100% 0, 100% 100%, 50% 100%, 0 100%, 0 21%);
  clip-path: polygon(24% 0, 100% 0, 100% 100%, 50% 100%, 0 100%, 0 21%);
}

.features-wrapper .features-banner {
  height: 471px;
  background-color: #eee;
  border-radius: 7px;
  width: 100%;
}

.features-wrapper .feature-cta {
  margin-top: 30px;
  border-radius: 7px;
  padding: 40px 60px;
  background-color: <?=$ayar['renk']?>;
}

.features-wrapper .feature-cta p {
  font-weight: 500;
  font-size: 20px;
}

.single-features-item {
  border-radius: 7px;
  background-color: #fff;
  -webkit-box-shadow: 0px 10px 60px 0px rgba(200, 226, 255, 0.45);
          box-shadow: 0px 10px 60px 0px rgba(200, 226, 255, 0.45);
  overflow: hidden;
  margin-top: 30px;
  padding: 30px 35px;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
}

@media (max-width: 991px) {
  .single-features-item {
    padding: 25px 20px;
  }
}

.single-features-item:hover h3 {
  color: <?=$ayar['renk']?>;
}

.single-features-item .icon {
  font-size: 60px;
  line-height: 1;
  color: <?=$ayar['renk']?>;
  float: left;
  overflow: hidden;
  margin-right: 25px;
}

@media (max-width: 991px) {
  .single-features-item .icon {
    margin-right: 20px;
  }
}

.single-features-item .content {
  overflow: auto;
}

.single-features-item .content h3 {
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.features-2 {
  background-color: #eef4fc;
  z-index: 1;
  position: relative;
  overflow: hidden;
}

.features-2 .feature-bg {
  position: absolute;
  right: 0;
  bottom: -20px;
  content: "";
  z-index: -1;
  width: 100%;
  height: 220px;
}

.icon-box {
  padding: 40px 30px 35px;
  border-radius: 7px;
  background-color: #fff;
  -webkit-transition: all .4s ease-in-out;
  transition: all .4s ease-in-out;
  text-align: center;
  margin-top: 30px;
}

.icon-box:hover {
  background-color: <?=$ayar['renk']?>;
  -webkit-box-shadow: 0px 10px 60px 0px rgba(8, 106, 215, 0.49);
          box-shadow: 0px 10px 60px 0px rgba(8, 106, 215, 0.49);
}

.icon-box:hover .icon {
  color: #fff;
}

.icon-box:hover h4 {
  color: #fff;
}

.icon-box .icon {
  font-size: 60px;
  color: <?=$ayar['renk']?>;
  margin-bottom: 15px;
  -webkit-transition: all .4s ease-in-out;
  transition: all .4s ease-in-out;
}

.icon-box h4 {
  color: #211e3b;
  text-transform: capitalize;
  font-size: 18px;
  margin-top: 10px;
}

.work-process-wrapper {
  background-color: #eef4fc;
}

/* ----------------------------------
  Service Section Styles
 ------------------------------------ */
.single-service-item {
  text-align: center;
  padding: 50px 30px;
  border-width: 2px;
  border-color: #312e49;
  border-style: solid;
  border-radius: 7px;
  margin-top: 30px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.single-service-item:hover {
  border: 2px solid #2e2a50;
  background-color: #2e2a50;
}

.single-service-item .icon {
  margin-bottom: 30px;
}

.single-service-item h4 {
  color: #fff;
}

.single-service-item p {
  margin-top: 10px;
  color: #9a95c0;
}

.single-service-item a {
  margin-top: 20px;
  color: #9a95c0;
  text-transform: uppercase;
  font-size: 13px;
  display: block;
  line-height: 1;
}

.single-service-item a i {
  margin-left: 10px;
}

.single-service-box {
  border-radius: 7px;
  background-color: #fff;
  text-align: center;
  position: relative;
  z-index: 1;
  -webkit-transition: all .4s ease-in-out;
  transition: all .4s ease-in-out;
  padding: 20px;
  overflow: hidden;
  margin-top: 30px;
}

.single-service-box:hover .content-overlay {
  opacity: 1;
  visibility: visible;
  -webkit-transform: translateY(0);
          transform: translateY(0);
}

.single-service-box:hover .icon img {
  -webkit-transform: scale(1.2);
          transform: scale(1.2);
}

.single-service-box .icon {
  border-radius: 7px;
  height: 230px;
  width: 100%;
  overflow: hidden;
  -webkit-transition: all .4s ease-in-out;
  transition: all .4s ease-in-out;
  background-color: #eee;
}

.single-service-box .icon img {
  -webkit-transition: all .4s ease-in-out;
  transition: all .4s ease-in-out;
}

.single-service-box h4 {
  font-size: 22px;
}

.single-service-box p {
  margin-top: 5px;
}

.single-service-box .read-link {
  color: <?=$ayar['renk']?>;
  text-transform: uppercase;
  font-size: 14px;
  font-weight: 700;
  margin-top: 5px;
  display: block;
}

.single-service-box .read-link i {
  margin-left: 10px;
}

.single-service-box .content-visible {
  -webkit-transition: all .4s ease-in-out;
  transition: all .4s ease-in-out;
  margin-top: 20px;
}

.single-service-box .content-overlay {
  padding: 20px 30px;
  opacity: 0;
  visibility: hidden;
  background-color: #fff;
  position: absolute;
  content: "";
  bottom: 0;
  left: 0;
  -webkit-transition: all .4s ease-in-out;
  transition: all .4s ease-in-out;
  -webkit-transform: translateY(30%);
          transform: translateY(30%);
}

.single-service-box .content-overlay h4 {
  margin-bottom: 5px;
}

.single-service-card {
  margin-top: 30px;
}

.single-service-card:hover .icon {
  -webkit-transform: rotate(360deg);
          transform: rotate(360deg);
}

.single-service-card .service-thumb {
  height: 435px;
  background-color: <?=$ayar['renk']?>;
  position: relative;
}

@media (max-width: 991px) {
  .single-service-card .service-thumb {
    height: 300px;
  }
}

.single-service-card .content {
  width: 80%;
  margin: 0 auto;
  background-color: #fff;
  border-radius: 7px;
  margin-top: -120px;
  position: relative;
  z-index: 9;
  padding: 40px 30px;
  padding-bottom: 30px;
  -webkit-box-shadow: 0px 10px 60px 0px rgba(200, 226, 255, 0.45);
          box-shadow: 0px 10px 60px 0px rgba(200, 226, 255, 0.45);
}

.single-service-card .content .icon {
  font-size: 64px;
  line-height: 1;
  margin-bottom: 5px;
  color: <?=$ayar['renk']?>;
  -webkit-transition: all .4s ease-in-out;
  transition: all .4s ease-in-out;
}

.single-service-card .content h3:hover a {
  color: <?=$ayar['renk']?>;
}

.single-service-card .content p {
  margin-top: 10px;
  font-size: 16px;
  line-height: 28px;
}

.service-2 {
  background-position: right bottom;
}

.service-3 {
  position: relative;
  z-index: 1;
}

.service-3::before {
  position: absolute;
  width: 100%;
  height: 50%;
  bottom: 0;
  content: "";
  left: 0;
  z-index: -1;
  background-color: #eef4fc;
}

@media (min-width: 1367px) {
  .service-3 .container-fluid {
    padding: 0px 175px;
  }
}

.single-service-vcard {
  background-color: #fff;
  position: relative;
  padding: 35px;
  margin-top: 30px;
  -webkit-clip-path: polygon(87% 0, 100% 13%, 100% 78%, 100% 100%, 0 100%, 0 0);
  clip-path: polygon(87% 0, 100% 13%, 100% 78%, 100% 100%, 0 100%, 0 0);
}

.single-service-vcard:hover .link {
  border-color: <?=$ayar['renk']?>;
  background-color: <?=$ayar['renk']?>;
  color: #fff;
}

.single-service-vcard .link {
  border-width: 2px;
  border-color: #efeff1;
  border-style: solid;
  border-radius: 5px;
  width: 36px;
  height: 36px;
  color: <?=$ayar['renk']?>;
  text-align: center;
  line-height: 36px;
  font-size: 14px;
  display: inline-block;
  float: right;
  margin-top: -10px;
}

.single-service-vcard .icon {
  font-size: 46px;
  color: <?=$ayar['renk']?>;
  margin-top: 5px;
  margin-bottom: 20px;
}

.single-service-vcard .content h3 {
  font-size: 20px;
  margin-bottom: 5px;
}

.single-service {
  margin-top: 40px;
  padding-right: 30px;
}

.single-service .icon {
  font-size: 46px;
  line-height: 1;
  color: <?=$ayar['renk']?>;
  margin-bottom: 15px;
}

.single-service .content p {
  margin-top: 10px;
  color: #696969;
}

.single-our-service {
  position: relative;
  margin-top: 30px;
}

.single-our-service::before {
  position: absolute;
  left: 0;
  bottom: 0;
  content: "";
  width: 100%;
  height: 100%;
  background-image: -webkit-gradient(linear, left bottom, left top, from(#211e3b), color-stop(65%, rgba(33, 30, 59, 0.5)), to(rgba(33, 30, 59, 0)));
  background-image: linear-gradient(0deg, #211e3b 0%, rgba(33, 30, 59, 0.5) 65%, rgba(33, 30, 59, 0) 100%);
}

.single-our-service .thumb {
  height: 370px;
  position: relative;
  background-color: #eee;
  z-index: -1;
}

.single-our-service .thumb::after {
  position: absolute;
  left: 0;
  bottom: 0;
  content: "";
  width: 100%;
  height: 100%;
  background-image: -webkit-gradient(linear, left bottom, left top, from(#211e3b), color-stop(65%, rgba(33, 30, 59, 0.5)), to(rgba(33, 30, 59, 0)));
  background-image: linear-gradient(0deg, #211e3b 0%, rgba(33, 30, 59, 0.5) 65%, rgba(33, 30, 59, 0) 100%);
}

.single-our-service .content {
  margin-top: -90px;
  position: relative;
  z-index: 1;
  padding: 30px;
  padding-top: 0;
  border: 1px solid #2c2945;
  border-top: 0px;
}

.single-our-service .content .icon {
  font-size: 60px;
  line-height: 1;
  margin-bottom: 20px;
}

.single-our-service .content h3 {
  margin-bottom: 10px;
}

.single-our-service .content p {
  color: #a9a9af !important;
}

.service-sidebar {
  margin-top: -50px;
}

.service-sidebar .single-sidebar-widgets {
  margin-top: 50px;
}

.service-sidebar .single-sidebar-widgets .wid-title {
  margin-bottom: 20px;
}

.service-sidebar .single-sidebar-widgets .wid-title h3 {
  font-weight: 700;
}

.service-sidebar .single-sidebar-widgets .services-category-link a {
  display: block;
  padding: 18px 35px;
  line-height: 1;
  background: #f5f5f5;
  margin-bottom: 10px;
}

.service-sidebar .single-sidebar-widgets .services-category-link a:hover {
  background: <?=$ayar['renk']?>;
  color: #fff;
}

.service-sidebar .single-sidebar-widgets .contact-form-widgets form {
  width: 100%;
}

.service-sidebar .single-sidebar-widgets .contact-form-widgets form input {
  padding: 15px 35px;
  line-height: 1;
  border: 0;
  color: <?=$ayar['renk']?>;
  width: 100%;
  background-color: #f5f5f5;
  margin-bottom: 20px;
}

.service-sidebar .single-sidebar-widgets .contact-form-widgets form textarea {
  border: 0;
  color: <?=$ayar['renk']?>;
  width: 100%;
  background-color: #f5f5f5;
  min-height: 140px;
  padding: 15px 35px;
}

.service-sidebar .single-sidebar-widgets .contact-form-widgets form .theme-btn {
  margin-top: 10px;
  display: block;
}

.service-sidebar .single-sidebar-widgets .download-service-doc a:first-child {
  margin-bottom: 20px;
}

.service-sidebar .single-sidebar-widgets .theme-btn {
  width: 100%;
  display: block;
  text-align: center;
}

.service-details-content img {
  margin-bottom: 30px;
}

.service-details-content h1, .service-details-content h3, .service-details-content h4, .service-details-content h2, .service-details-content h5, .service-details-content h6 {
  margin-bottom: 30px;
}

.service-details-content p {
  margin-bottom: 30px;
}

.service-details-content p:last-child {
  margin-bottom: 0;
}

.service-details-content ul {
  margin-bottom: 30px;
}

.service-details-content ul li {
  color: #211e3b;
  margin-top: 8px;
  padding-left: 40px;
  font-weight: 700;
}

.service-details-content ul li::before {
  position: absolute;
  top: 0;
  left: 0;
  content: "\f058";
  font-family: "Font Awesome 5 Pro";
  font-weight: 700;
  font-size: 25px;
  color: <?=$ayar['renk']?>;
}

.testimonial-wrapper {
  position: relative;
  z-index: 1;
}

.testimonial-wrapper .testimonial-bg {
  position: absolute;
  width: 50%;
  height: 100%;
  background-color: #fff;
  left: 0;
  top: 0;
}

@media (max-width: 1199px) {
  .testimonial-wrapper .testimonial-bg {
    width: 30%;
  }
}

@media (max-width: 991px) {
  .testimonial-wrapper .testimonial-bg {
    background-image: inherit;
    background: <?=$ayar['renk']?>;
    opacity: .2;
  }
}

.testimonial-wrapper .owl-dots .owl-dot {
  border-width: 3px;
  border-color: transparent;
  border-style: solid;
  border-radius: 50%;
  width: 24px;
  height: 24px;
  display: inline-block;
  line-height: 24px;
  -webkit-box-sizing: border-box;
          box-sizing: border-box;
  text-align: center;
  position: relative;
  margin: 0px 5px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.testimonial-wrapper .owl-dots .owl-dot:hover, .testimonial-wrapper .owl-dots .owl-dot.active {
  border-color: <?=$ayar['renk']?>;
}

.testimonial-wrapper .owl-dots .owl-dot:hover span, .testimonial-wrapper .owl-dots .owl-dot.active span {
  background-color: <?=$ayar['renk']?>;
}

.testimonial-wrapper .owl-dots .owl-dot span {
  background-color: #dae9f9;
  margin: 0;
  line-height: 24px;
  position: absolute;
  top: 50%;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  left: 50%;
  margin-left: -5px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.single-testimonial .icon {
  font-size: 100px;
  color: <?=$ayar['renk']?>;
  line-height: 1;
}

@media (max-width: 991px) {
  .single-testimonial .icon {
    font-size: 80px;
  }
}

@media (max-width: 767px) {
  .single-testimonial .icon {
    font-size: 60px;
  }
}

.single-testimonial h2 {
  font-weight: 400 !important;
  font-style: italic;
  font-size: 30px;
  line-height: 140%;
}

@media (max-width: 767px) {
  .single-testimonial h2 {
    font-size: 26px;
    letter-spacing: -2px;
  }
}

@media (max-width: 375px) {
  .single-testimonial h2 {
    font-size: 24px;
    font-style: normal;
  }
}

.single-testimonial .client-info {
  margin-top: 30px;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
}

.single-testimonial .client-info .client-img {
  border-radius: 50%;
  background-color: #eee;
  width: 70px;
  height: 70px;
  line-height: 70px;
  float: left;
  overflow: hidden;
  margin-right: 25px;
}

@media (max-width: 767px) {
  .single-testimonial .client-info .client-img {
    margin-right: 20px;
  }
}

.single-testimonial .client-info .client-bio {
  overflow: auto;
}

.single-testimonial .client-info .client-bio h3 {
  font-size: 25px;
}

.single-testimonial .client-info .client-bio p {
  color: <?=$ayar['renk']?>;
  font-weight: 500;
}

.testimonial-carousel-2 {
  padding-left: -10px;
  padding-right: -10px;
  position: relative;
}

@media (max-width: 991px) {
  .testimonial-carousel-2 {
    margin-bottom: -30px;
  }
}

@media (max-width: 767px) {
  .testimonial-carousel-2 {
    margin-bottom: -50px;
  }
}

.testimonial-carousel-2 .owl-dots .owl-dot {
  border-width: 3px;
  border-color: transparent;
  border-style: solid;
  border-radius: 50%;
  width: 24px;
  height: 24px;
  display: inline-block;
  line-height: 24px;
  -webkit-box-sizing: border-box;
          box-sizing: border-box;
  text-align: center;
  position: relative;
  margin: 0px 5px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.testimonial-carousel-2 .owl-dots .owl-dot:hover, .testimonial-carousel-2 .owl-dots .owl-dot.active {
  border-color: <?=$ayar['renk']?>;
}

.testimonial-carousel-2 .owl-dots .owl-dot:hover span, .testimonial-carousel-2 .owl-dots .owl-dot.active span {
  background-color: <?=$ayar['renk']?>;
}

.testimonial-carousel-2 .owl-dots .owl-dot span {
  background-color: #dae9f9;
  margin: 0;
  line-height: 24px;
  position: absolute;
  top: 50%;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  left: 50%;
  margin-left: -5px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.testimonial-carousel-2 .owl-stage-outer {
  padding: 0 10px;
  margin-right: -15px;
}

.testimonial-carousel-2 .single-testimonial {
  border: 1px solid #eee;
  border-radius: 7px;
  padding: 50px 65px 70px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
  position: relative;
  background-color: #fff;
  margin-bottom: 80px;
  margin-top: 80px;
}

@media (max-width: 991px) {
  .testimonial-carousel-2 .single-testimonial {
    margin-bottom: 50px;
    margin-top: 50px;
  }
}

@media (max-width: 767px) {
  .testimonial-carousel-2 .single-testimonial {
    margin-bottom: 30px;
    margin-top: 30px;
    padding: 30px 30px 50px;
  }
}

.testimonial-carousel-2 .single-testimonial::before {
  position: absolute;
  width: 100%;
  height: 100%;
  background: <?=$ayar['renk']?>;
  border-radius: 7px;
  content: "";
  left: 0;
  top: 0;
  z-index: -1;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
  opacity: 0;
  visibility: hidden;
}

.testimonial-carousel-2 .single-testimonial:hover, .testimonial-carousel-2 .single-testimonial.active {
  background-color: #fff;
  border-color: #fff;
  -webkit-box-shadow: 0px 10px 60px 0px rgba(8, 106, 215, 0.1);
          box-shadow: 0px 10px 60px 0px rgba(8, 106, 215, 0.1);
}

.testimonial-carousel-2 .single-testimonial:hover::before, .testimonial-carousel-2 .single-testimonial.active::before {
  opacity: 1;
  visibility: visible;
  top: -10px;
  left: -10px;
}

@media (max-width: 767px) {
  .testimonial-carousel-2 .single-testimonial .client-info .client-bio h3 {
    font-size: 18px;
    line-height: 1;
  }
}

@media (max-width: 767px) {
  .testimonial-carousel-2 .single-testimonial .client-info .client-bio p {
    font-size: 15px;
  }
}

.brand-logo-grid {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-pack: justify;
      -ms-flex-pack: justify;
          justify-content: space-between;
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
}

.project-wrapper {
  position: relative;
}

.project-wrapper .portfolio-carousel-active .single-project .project-contents {
  background-color: #f7f7f7;
  border-radius: 10px;
  position: relative;
  margin-top: 60px;
}

.project-wrapper .portfolio-carousel-active .single-project .project-details {
  padding: 100px 0px;
}

.project-wrapper .portfolio-carousel-active .single-project .project-details .project-meta .project-cat {
  margin-right: 30px;
}

.project-wrapper .portfolio-carousel-active .single-project .project-details .project-meta .client-info span {
  color: #000;
  font-weight: 600;
  padding-right: 5px;
}

.project-wrapper .portfolio-carousel-active .single-project .project-details .project-meta .client-info i {
  color: #000;
  font-weight: 500;
}

.project-wrapper .portfolio-carousel-active .single-project .project-details h2 {
  font-size: 40px;
  line-height: 50px;
  margin-top: 5px;
}

.project-wrapper .portfolio-carousel-active .single-project .project-details p {
  margin-top: 15px;
}

.project-wrapper .portfolio-carousel-active .single-project .project-details .read-btn {
  margin-top: 35px;
}

.project-wrapper .portfolio-carousel-active .single-project .project-thumbnail {
  position: relative;
  height: 512px;
  background-color: #dddddd;
  border-radius: 10px;
  margin-top: -60px;
  overflow: hidden;
}

.project-wrapper .portfolio-carousel-active .single-project .project-thumbnail .popup-gallery {
  display: block;
  width: 100%;
  height: 100%;
}

.project-wrapper .portfolio-carousel-active .single-project .project-thumbnail .popup-gallery img {
  max-width: 100%;
  width: 100%;
}

.project-wrapper .project-carousel-nav {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  position: absolute;
  right: 95px;
  bottom: 0;
  z-index: 9999;
  overflow: hidden;
  border-radius: 10px;
  -webkit-transform: translateY(50%);
          transform: translateY(50%);
}

.project-wrapper .project-carousel-nav div {
  width: 80px;
  height: 80px;
  line-height: 80px;
  text-align: center;
  font-size: 24px;
  color: #fff;
  -webkit-transition: all .4s ease-in-out;
  transition: all .4s ease-in-out;
  background: <?=$ayar['renk']?>;
  cursor: pointer;
}

.project-wrapper .project-carousel-nav div.owl-next {
  background: #febc35;
}

.portfolio-cat-filter button {
  border: none;
  background-color: #f8f8f8;
  display: inline-block;
  padding: 15px 35px;
  line-height: 1;
  text-transform: capitalize;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
  border-radius: 30px;
  margin: 0px 3px;
  font-weight: 600;
  margin-top: 30px;
}

@media (max-width: 767px) {
  .portfolio-cat-filter button {
    padding: 15px 25px;
    font-size: 14px;
    margin-bottom: 10px;
  }
}

.portfolio-cat-filter button.active, .portfolio-cat-filter button:hover {
  color: #fff;
  background-color: #ff5e14;
}

.portfolio-carousel-wrapper .center .single-project-item .project-details {
  -webkit-transform: translateY(0);
          transform: translateY(0);
  opacity: 1;
  visibility: visible;
}

.portfolio-carousel-wrapper .single-project-item {
  padding-bottom: 30px;
}

.portfolio-carousel-wrapper .single-project-item:hover .project-details {
  -webkit-transform: translateY(0);
          transform: translateY(0);
  opacity: 1;
  visibility: visible;
}

.portfolio-carousel-wrapper .single-project-item .project-thumb {
  height: 450px;
  background-color: #eee;
  position: relative;
}

.portfolio-carousel-wrapper .single-project-item .project-details {
  position: relative;
  background-color: #fff;
  width: 90%;
  margin: 0px auto;
  z-index: 3;
  -webkit-box-shadow: 0px 16px 32px 0px rgba(0, 0, 0, 0.04);
          box-shadow: 0px 16px 32px 0px rgba(0, 0, 0, 0.04);
  padding: 25px 35px;
  margin-top: -60px;
  z-index: 1;
  opacity: 0;
  visibility: hidden;
  -webkit-transition: all .4s ease-in-out;
  transition: all .4s ease-in-out;
  -webkit-transform: translateY(30px);
          transform: translateY(30px);
}

.portfolio-carousel-wrapper .single-project-item .project-details::before {
  position: absolute;
  width: 90%;
  left: 50%;
  bottom: -10px;
  -webkit-transform: translateX(-50%);
          transform: translateX(-50%);
  background-color: #ffd039;
  z-index: -1;
  content: "";
  height: 10px;
}

.portfolio-carousel-wrapper .single-project-item .project-details .icon {
  display: inline-block;
  position: absolute;
  right: 30px;
  top: 0;
  padding: 10px 30px;
  background-color: #ffd039;
  color: #001248;
  text-align: center;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  -webkit-clip-path: polygon(25% 0%, 100% 0%, 75% 100%, 0% 100%);
  clip-path: polygon(25% 0%, 100% 0%, 75% 100%, 0% 100%);
}

.portfolio-carousel-wrapper .single-project-item .project-details .meta span:last-child {
  color: #001248;
  font-weight: 600;
}

.portfolio-carousel-wrapper .single-project-item .project-details h3 {
  color: #001248;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.portfolio-carousel-wrapper .single-project-item .project-details h3:hover {
  color: #ffd039;
}

.case-cat-filter button {
  display: inline-block;
  border: 0;
  font-size: 14px;
  line-height: 1;
  padding: 9px 15px;
  border-radius: 7px;
  background-color: #fff;
  color: #211e3b;
  text-transform: capitalize;
  -webkit-box-shadow: 0px 10px 60px 0px rgba(121, 121, 121, 0.45);
          box-shadow: 0px 10px 60px 0px rgba(121, 121, 121, 0.45);
  margin-left: 10px;
}

@media (max-width: 991px) {
  .case-cat-filter button {
    margin-top: 10px;
    margin-right: 8px;
  }
}

.single-case-study {
  border-radius: 7px;
  background-color: #fff;
  -webkit-box-shadow: 0px 10px 60px 0px rgba(200, 226, 255, 0.45);
          box-shadow: 0px 10px 60px 0px rgba(200, 226, 255, 0.45);
  margin-top: 30px;
}

.single-case-study .features-thumb {
  border-radius: 7px;
  height: 285px;
  background-color: #eee;
}

.single-case-study .content {
  padding: 33px 35px;
}

.single-case-study .content s h3 {
  margin-bottom: 5px;
  margin-top: -5px;
}

.single-case-study .content a {
  color: <?=$ayar['renk']?>;
  text-transform: uppercase;
  margin-top: 15px;
  font-size: 14px;
  line-height: 1;
  display: block;
}

.single-case-study .content a i {
  margin-left: 10px;
}

.case-study-carousel-wrapper {
  position: relative;
  z-index: 1;
}

.case-study-carousel-wrapper::before {
  position: absolute;
  width: 100%;
  height: 50%;
  background-color: #eef4fc;
  content: "";
  left: 0;
  bottom: 0;
  z-index: -1;
}

.case-study-carousel-wrapper.style-2::before {
  bottom: auto;
  top: 0;
}

.case-study-carousel-wrapper .work-process-nav div {
  border-radius: 5px;
  width: 55px;
  height: 55px;
  display: inline-block;
  line-height: 55px;
  text-align: center;
  background-color: #d7e6f8;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
  margin-left: 10px;
  cursor: pointer;
}

.case-study-carousel-wrapper .work-process-nav div:hover {
  background-color: <?=$ayar['renk']?>;
  color: #fff;
}

@media (max-width: 991px) {
  .case-study-carousel-wrapper .work-process-nav div {
    margin-left: 0;
    margin-right: 10px;
  }
}

.case-study-items .single-case-item, .case-study-2 .single-case-item {
  text-align: center;
  overflow: hidden;
}

.case-study-items .single-case-item:hover .overlay-content, .case-study-2 .single-case-item:hover .overlay-content {
  opacity: 1;
  visibility: visible;
  -webkit-transform: translateY(0);
          transform: translateY(0);
}

.case-study-items .single-case-item .case-thumb, .case-study-2 .single-case-item .case-thumb {
  height: 370px;
  border-radius: 7px;
  position: relative;
}

.case-study-items .single-case-item .contents, .case-study-2 .single-case-item .contents {
  width: 90%;
  margin: 0 auto;
  background-color: #fff;
  border-radius: 7px;
  margin-top: -50px;
  position: relative;
  z-index: 9;
}

.case-study-items .single-case-item .content-visible, .case-study-2 .single-case-item .content-visible {
  padding: 20px 30px 15px;
  position: relative;
  display: inline-block;
}

.case-study-items .single-case-item .content-visible h3, .case-study-2 .single-case-item .content-visible h3 {
  margin-bottom: 5px;
}

.case-study-items .single-case-item .content-visible span, .case-study-2 .single-case-item .content-visible span {
  color: <?=$ayar['renk']?>;
  line-height: 1;
}

.case-study-items .single-case-item .overlay-content, .case-study-2 .single-case-item .overlay-content {
  opacity: 0;
  visibility: hidden;
  -webkit-transition: all .4s ease-in-out;
  transition: all .4s ease-in-out;
  padding: 35px 30px;
  position: absolute;
  bottom: 0;
  width: 100%;
  background-color: #fff;
  border-radius: 7px;
  -webkit-transform: translateY(50px);
          transform: translateY(50px);
}

.case-study-items .single-case-item .overlay-content p, .case-study-2 .single-case-item .overlay-content p {
  margin-top: 10px;
  font-size: 16px;
}

.case-study-items .single-case-item .overlay-content .theme-btn, .case-study-2 .single-case-item .overlay-content .theme-btn {
  padding: 16px 35px;
  font-size: 14px;
  margin-top: 20px;
}

.case-study-items .single-case-item .overlay-content .theme-btn i, .case-study-2 .single-case-item .overlay-content .theme-btn i {
  margin-right: 10px;
}

.case-study-2 {
  margin-top: -30px;
}

.case-study-2 .single-case-item {
  margin-top: 30px;
}

.case-study-2 .single-case-item .contents {
  -webkit-box-shadow: 0px 10px 30px 0px rgba(8, 106, 215, 0.1);
          box-shadow: 0px 10px 30px 0px rgba(8, 106, 215, 0.1);
}

.case-grid-photos {
  display: -ms-grid;
  display: grid;
  -ms-grid-columns: 1fr 1fr;
      grid-template-columns: 1fr 1fr;
  -ms-grid-rows: auto;
      grid-template-rows: auto;
  grid-gap: 30px;
}

@media (max-width: 767px) {
  .case-grid-photos {
    -ms-grid-columns: 1fr;
        grid-template-columns: 1fr;
  }
}

.case-study-post-wrapper .case-details-content {
  margin-top: 40px;
}

.case-study-post-wrapper .case-details-content p {
  margin-bottom: 20px;
  margin-top: 10px;
}

.case-study-post-wrapper .case-details-content p:nth-child(1)::first-letter {
  font-size: 20px;
  color: #fff;
  border-radius: 7px;
  background-color: <?=$ayar['renk']?>;
  -webkit-box-shadow: 0px 10px 30px 0px rgba(8, 106, 215, 0.5);
          box-shadow: 0px 10px 30px 0px rgba(8, 106, 215, 0.5);
  padding: 20px;
  line-height: 1;
  margin-right: 15px;
  float: left;
  overflow: hidden;
  font-weight: 700;
  text-transform: uppercase;
}

.case-study-post-wrapper .case-details-content ul {
  margin-top: 20px;
}

.case-study-post-wrapper .case-details-content ul li {
  color: #211e3b;
  margin-top: 8px;
  padding-left: 40px;
  font-weight: 700;
}

.case-study-post-wrapper .case-details-content ul li::before {
  position: absolute;
  top: 0;
  left: 0;
  content: "\f058";
  font-family: "Font Awesome 5 Pro";
  font-size: 25px;
  color: <?=$ayar['renk']?>;
}

.case-info-card {
  border-radius: 7px;
  overflow: hidden;
  background-color: #fff;
  border-radius: 7px;
  -webkit-box-shadow: 0px 10px 60px 0px rgba(212, 212, 212, 0.38);
          box-shadow: 0px 10px 60px 0px rgba(212, 212, 212, 0.38);
  margin-top: -70px;
  position: relative;
}

@media (max-width: 991px) {
  .case-info-card {
    margin-top: 30px;
  }
}

.case-info-card .case-head {
  padding: 20px 35px;
  background-color: <?=$ayar['renk']?>;
}

.case-info-card .case-head h3 {
  color: #fff;
}

.case-info-card .project-data {
  padding: 35px;
}

.case-info-card .project-data .single-info-item {
  display: -ms-grid;
  display: grid;
  -ms-grid-columns: 30% 65%;
      grid-template-columns: 30% 65%;
  -ms-grid-rows: auto;
      grid-template-rows: auto;
  grid-gap: 50px;
  margin-bottom: 10px;
}

.case-info-card .project-data .single-info-item .left-data {
  color: #74787c;
  position: relative;
}

.case-info-card .project-data .single-info-item .left-data::before {
  position: absolute;
  right: -10px;
  content: ":";
}

.case-info-card .project-data .single-info-item .right-data {
  color: #211e3b;
  font-weight: 700;
}

.case-info-card .project-data .single-info-item .social-link a {
  display: inline-block;
  margin: 0px 4px;
  color: <?=$ayar['renk']?>;
  font-weight: 400;
}

.project-case-study {
  padding: 0px 30px;
}

.project-case-study.owl-carousel .owl-item.center .single-project-card .contents {
  opacity: 1;
  visibility: visible;
  bottom: 30px;
}

.project-case-study .single-project-card {
  -webkit-clip-path: polygon(13% 0, 100% 0, 100% 100%, 52% 100%, 0 100%, 0 14%);
  clip-path: polygon(13% 0, 100% 0, 100% 100%, 52% 100%, 0 100%, 0 14%);
  position: relative;
  margin-top: 30px;
}

.project-case-study .single-project-card .case-thumb {
  height: 530px;
}

@media (max-width: 585px) {
  .project-case-study .single-project-card .case-thumb {
    height: 400px;
  }
}

.project-case-study .single-project-card .contents {
  width: 90%;
  background-color: #fff;
  border-radius: 7px;
  position: absolute;
  left: 50%;
  bottom: 0px;
  -webkit-transform: translateX(-50%);
          transform: translateX(-50%);
  z-index: 9;
  padding: 30px;
  opacity: 0;
  visibility: hidden;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

@media (max-width: 585px) {
  .project-case-study .single-project-card .contents {
    width: 95%;
  }
  .project-case-study .single-project-card .contents p {
    font-size: 15px;
    line-height: 140%;
  }
}

.project-case-study .single-project-card .contents h3 {
  margin-bottom: 20px;
}

@media (max-width: 585px) {
  .project-case-study .single-project-card .contents h3 {
    margin-bottom: 10px;
  }
}

.project-case-study .single-project-card .contents .theme-btn {
  margin-top: 20px;
}

@media (max-width: 585px) {
  .project-case-study .single-project-card .contents .theme-btn {
    margin-top: 15px;
  }
}

.project-case-study .owl-dots {
  margin-top: 30px !important;
  margin-bottom: -10px;
}

.project-case-study .owl-dots .owl-dot {
  border-width: 3px;
  border-color: transparent;
  border-style: solid;
  border-radius: 50%;
  width: 24px;
  height: 24px;
  display: inline-block;
  line-height: 24px;
  -webkit-box-sizing: border-box;
          box-sizing: border-box;
  text-align: center;
  position: relative;
  margin: 0px 5px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.project-case-study .owl-dots .owl-dot:hover, .project-case-study .owl-dots .owl-dot.active {
  border-color: <?=$ayar['renk']?>;
}

.project-case-study .owl-dots .owl-dot:hover span, .project-case-study .owl-dots .owl-dot.active span {
  background-color: <?=$ayar['renk']?>;
}

.project-case-study .owl-dots .owl-dot span {
  background-color: #dae9f9;
  margin: 0;
  line-height: 24px;
  position: absolute;
  top: 50%;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  left: 50%;
  margin-left: -5px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.single-pricing-plan {
  padding: 50px 45px;
  border-width: 2px;
  border-color: #312e49;
  border-style: solid;
  border-radius: 7px;
  margin-top: 40px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
  position: relative;
  z-index: 1;
}

.single-pricing-plan.style-2 {
  background-color: #fff;
  border-color: #fff;
  margin-top: 0px !important;
}

.single-pricing-plan.style-2 h3, .single-pricing-plan.style-2 h2, .single-pricing-plan.style-2 span {
  color: #211e3b !important;
}

.single-pricing-plan.style-2 .theme-btn {
  border-color: #efeff1;
  background-color: transparent;
  color: #211e3b;
}

.single-pricing-plan.style-2 .plan-features li {
  color: #696969 !important;
}

.single-pricing-plan.style-2 .plan-features li::before {
  color: <?=$ayar['renk']?>;
}

.single-pricing-plan.style-2:hover h3, .single-pricing-plan.style-2:hover h2, .single-pricing-plan.style-2:hover span, .single-pricing-plan.style-2.active h3, .single-pricing-plan.style-2.active h2, .single-pricing-plan.style-2.active span {
  color: #fff !important;
}

.single-pricing-plan.style-2:hover .theme-btn, .single-pricing-plan.style-2.active .theme-btn {
  background-color: #fff;
  border-color: #fff;
  color: <?=$ayar['renk']?>;
}

.single-pricing-plan.style-2:hover .plan-features li, .single-pricing-plan.style-2.active .plan-features li {
  color: #fff !important;
}

.single-pricing-plan.style-2:hover .plan-features li::before, .single-pricing-plan.style-2.active .plan-features li::before {
  color: #fff;
}

.single-pricing-plan:hover, .single-pricing-plan.active {
  background-color: <?=$ayar['renk']?>;
  border-color: <?=$ayar['renk']?>;
}

.single-pricing-plan:hover p, .single-pricing-plan:hover h3, .single-pricing-plan:hover span, .single-pricing-plan.active p, .single-pricing-plan.active h3, .single-pricing-plan.active span {
  color: #fff !important;
}

.single-pricing-plan:hover a, .single-pricing-plan.active a {
  color: <?=$ayar['renk']?>;
  background-color: #fff;
  border-color: #fff;
}

.single-pricing-plan h3 {
  color: #fff;
  font-weight: 500;
  margin-bottom: 10px;
}

.single-pricing-plan p {
  color: #9a95c0;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.single-pricing-plan .pricing {
  margin-top: 15px;
  position: relative;
}

.single-pricing-plan .pricing span,
.single-pricing-plan .pricing h2,
.single-pricing-plan .pricing p {
  color: #fff;
  display: inline-block;
  font-weight: 400;
}

.single-pricing-plan .pricing span {
  position: absolute;
  font-size: 18px;
  top: 0;
}

.single-pricing-plan .pricing h2 {

  font-size: 42px;
  line-height: 1;
  padding-left: 18px;
  letter-spacing: -1px;
}

.single-pricing-plan .pricing p {
  color: #9a95c0;
  margin-left: 5px;
  text-transform: lowercase;
}

.single-pricing-plan .plan-features {
  margin-top: 30px;
}

.single-pricing-plan .plan-features li {
  position: relative;
  padding-left: 30px;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
  color: #a5beec;
  margin-bottom: 5px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.single-pricing-plan .plan-features li.active {
  color: #fff;
}

.single-pricing-plan .plan-features li::before {
  line-height: 1;
  font-family: "Font Awesome 5 Pro";
  position: absolute;
  content: "\f00c";
  z-index: -1;
  left: 0;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.single-pricing-plan .theme-btn {
  margin-top: 28px;
  border-color: #312e49;
  background-color: #312e49;
  color: #fff;
}

.single-pricing-plan .theme-btn i {
  margin-left: 10px;
}

@media (max-width: 1199px) {
  .our-pricing-wrapper .dot-circle {
    display: none;
  }
}

.our-pricing-wrapper.right-bg {
  position: relative;
}

.our-pricing-wrapper.right-bg::before {
  position: absolute;
  width: 50%;
  height: 100%;
  right: 0;
  top: 0;
  content: "";
  background-color: #eef4fc;
  z-index: -1;
}

@media (max-width: 1199px) {
  .our-pricing-wrapper.right-bg::before {
    width: 100%;
  }
}

/* ----------------------------------
	Call To Action Section Styles
 ------------------------------------ */
.cta-banner {
  position: relative;
  z-index: 3;
}

.cta-banner.style-2 .container-fluid {
  background-color: <?=$ayar['renk']?>;
}

.cta-banner.style-2 .container-fluid::after, .cta-banner.style-2 .container-fluid::before {
  border-color: #fff;
}

.cta-banner.style-2 .theme-btn:first-child {
  background-color: #fff;
  color: <?=$ayar['renk']?>;
}

.cta-banner .container-fluid {
  padding-top: 90px;
  padding-bottom: 85px;
  border-radius: 7px;
  position: relative;
  z-index: 3;
  margin: 0 auto;
}

@media (min-width: 1650px) {
  .cta-banner .container-fluid {
    max-width: 1600px;
    width: 100%;
  }
}

@media (max-width: 1649px) {
  .cta-banner .container-fluid {
    max-width: 96%;
    padding-left: 50px;
    padding-right: 50px;
  }
}

@media (max-width: 1199px) {
  .cta-banner .container-fluid {
    max-width: 90%;
  }
}

@media (max-width: 767px) {
  .cta-banner .container-fluid {
    max-width: 92%;
    padding: 50px 15px;
  }
}

@media (max-width: 500px) {
  .cta-banner .container-fluid {
    max-width: 96%;
    padding: 40px 20px;
  }
}

.cta-banner .container-fluid::after {
  border-width: 3px;
  border-color: #ff9600;
  border-style: solid;
  border-radius: 50%;
  position: absolute;
  width: 14px;
  height: 14px;
  right: 7%;
  top: 60px;
  content: "";
  z-index: -1;
}

@media (max-width: 767px) {
  .cta-banner .container-fluid::after {
    top: 30px;
  }
}

.cta-banner .container-fluid::before {
  border-width: 5px;
  border-color: #e8524a;
  border-style: solid;
  border-radius: 50%;
  position: absolute;
  width: 24px;
  height: 24px;
  left: 6%;
  bottom: 60px;
  content: "";
  z-index: -1;
}

.cta-banner .cta-content {
  max-width: 1170px;
  width: 100%;
  margin: 0px auto;
}

@media (max-width: 500px) {
  .cta-banner .cta-content h1 {
    font-size: 30px;
  }
}

.cta-banner .minimal-btn {
  color: #fff;
}

.video-section::before {
  position: absolute;
  left: 0;
  content: "";
  top: 0;
  background: <?=$ayar['renk']?>;
  width: 100%;
  height: 100%;
  opacity: .7;
  z-index: -1;
}

.video-section .section-title span {
  color: #00baa3;
}

.video-section .section-title h1 {
  color: #fff;
}

.subscribe-box-wrapper .subscribe_left_bg {
  position: absolute;
  left: 0;
  top: 0;
  width: 40%;
  height: 100%;
  content: "";
  background-color: #211e3b;
}

.subscribe-box-wrapper .cta-contents .icon {
  width: 100px;
  height: 100px;
  border-radius: 30px;
  color: #fff;
  font-size: 50px;
  line-height: 100px;
  text-align: center;
  background-color: <?=$ayar['renk']?>;
  margin-bottom: 40px;
}

.subscribe-box-wrapper .cta-contents p {
  margin-top: 25px;
  color: #cfcdcc;
  font-size: 20px;
}

.subscribe-box-wrapper .subscribe-form form {
  height: 74px;
  position: relative;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  margin-top: 55px;
}

.subscribe-box-wrapper .subscribe-form form input {
  border: 0px;
  width: 70%;
  position: relative;
  border-style: solid;
  border-width: 2px;
  border-right-width: 0px;
  border-color: #353839;
  border-radius: 10px 0px 0px 10px;
  background-color: rgba(255, 255, 255, 0.059);
  padding-left: 35px;
  padding-right: 15px;
  line-height: 1;
  color: #fff;
}

.subscribe-box-wrapper .subscribe-form form input::-webkit-input-placeholder {
  color: #999;
}

.subscribe-box-wrapper .subscribe-form form input:-ms-input-placeholder {
  color: #999;
}

.subscribe-box-wrapper .subscribe-form form input::-ms-input-placeholder {
  color: #999;
}

.subscribe-box-wrapper .subscribe-form form input::placeholder {
  color: #999;
}

.subscribe-box-wrapper .subscribe-form form button {
  width: 30%;
  height: 100%;
  background: <?=$ayar['renk']?>;
  color: #000;
  display: inline-block;
  border-radius: 0px 10px 10px 0px;
  font-size: 16px;
  line-height: 1;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
  font-weight: 700;
}

.subscribe-box-wrapper .subscribe-form form button:hover {
  color: #fff;
}

.cta-funfact-wrap {
  background: #211e3b;
}

.cta-funfact-wrap .fun-fact {
  background: #ff5e14;
  height: 140px;
}

.cta-funfact-wrap .fun-fact span {
  font-size: 80px;
  line-height: 1;
  font-weight: 700;
  margin: 0 10px;
}

.cta-funfact-wrap .cta-wrap {
  position: relative;
  z-index: 1;
  height: 140px;
}

.cta-funfact-wrap .cta-wrap::before {
  position: absolute;
  width: 200%;
  height: 100%;
  background-color: #211e3b;
  top: 0;
  left: -15px;
  content: "";
  z-index: -1;
}

.cta-funfact-wrap .cta-wrap h2 {
  font-size: 40px;
  line-height: 130%;
}

.cta-funfact-wrap .cta-wrap a {
  color: #ff5e14;
  text-decoration: underline;
  margin-right: -40px;
}

.cta-funfact-wrap .cta-wrap a i {
  margin-left: 10px;
}

.video_wrapper {
  border-style: solid;
  border-width: 10px;
  border-color: #fff;
  border-radius: 20px;
  background-color: #eee;
  -webkit-box-shadow: 0px 20px 40px 0px rgba(0, 0, 0, 0.06);
          box-shadow: 0px 20px 40px 0px rgba(0, 0, 0, 0.06);
  height: 475px;
}

@media (max-width: 767px) {
  .video_wrapper {
    height: 300px;
  }
}

.cta-banner-content {
  background-color: #eee;
  border-radius: 10px;
  padding: 50px 0px;
  position: relative;
  overflow: hidden;
}

.cta-banner-content::before {
  position: absolute;
  width: 100%;
  background-color: <?=$ayar['renk']?>;
  content: "";
  height: 100%;
  left: 0;
  top: 0;
  opacity: .9;
}

.cta-banner-content a {
  background-color: #fff;
  border-color: #fff;
  color: <?=$ayar['renk']?>;
}

.cta-content-banner-4 {
  background-color: <?=$ayar['renk']?>;
  padding: 50px 0px;
  -webkit-clip-path: polygon(50% 0%, 100% 0, 100% 78%, 97% 100%, 0 100%, 0 0);
  clip-path: polygon(50% 0%, 100% 0, 100% 78%, 97% 100%, 0 100%, 0 0);
}

@media (max-width: 767px) {
  .cta-content-banner-4 h1 {
    font-size: 28px;
  }
}

.cta-banner-5 {
  padding: 60px 60px 50px;
  border: 1px solid #e8e8eb;
  margin-top: 120px;
}

@media (max-width: 991px) {
  .cta-banner-5 {
    margin-top: 100px;
    padding: 40px 30px 40px;
  }
}

@media (max-width: 767px) {
  .cta-banner-5 {
    padding: 30px;
  }
  .cta-banner-5 p {
    font-size: 15px;
    line-height: 140%;
  }
}

.cta-banner-5 h2 {
  margin-bottom: 15px;
}

@media (max-width: 767px) {
  .cta-banner-5 h2 {
    font-size: 28px;
  }
}

.promo-featured-wrapper .featured-img {
  height: 556px;
  background-color: #eee;
  position: relative;
  margin-left: 60px;
  background-size: cover;
  background-position: center;
  margin-right: 60px;
}

.promo-featured-wrapper .top-img {
  width: 180px;
  height: 180px;
  background-color: #eee;
  left: -60px;
  top: -40px;
  position: absolute;
  -webkit-box-shadow: 0px 16px 32px 0px rgba(52, 52, 52, 0.04);
          box-shadow: 0px 16px 32px 0px rgba(52, 52, 52, 0.04);
}

.promo-featured-wrapper .bottom-img {
  border-style: solid;
  border-width: 10px;
  border-color: white;
  -webkit-box-shadow: 0px 16px 32px 0px rgba(52, 52, 52, 0.04);
          box-shadow: 0px 16px 32px 0px rgba(52, 52, 52, 0.04);
  background-color: #eee;
  position: absolute;
  width: 269px;
  height: 269px;
  right: -60px;
  bottom: -60px;
}

.features-list .single-item {
  overflow: hidden;
  margin-top: 40px;
}

.features-list .single-item .icon {
  background-color: #fff;
  border-radius: 50%;
  width: 100px;
  height: 100px;
  line-height: 100px;
  text-align: center;
  float: left;
  overflow: hidden;
  margin-right: 40px;
}

.features-list .single-item .content {
  overflow: hidden;
}

.features-list .single-item .content p {
  padding-left: 20px;
  margin-top: 15px;
  position: relative;
}

.features-list .single-item .content p::before {
  position: absolute;
  width: 2px;
  height: 42px;
  left: 0;
  top: 50%;
  content: "";
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  background: #ff5e14;
}

.video_bg {
  position: absolute;
  width: 50%;
  height: 100%;
  content: "";
  background-size: cover;
  right: 0;
  top: 0;
  z-index: -1;
}

.call-consultation {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
}

.call-consultation .icon {
  float: left;
  border-radius: 50%;
  background-color: <?=$ayar['renk']?>;
  width: 60px;
  height: 60px;
  line-height: 64px;
  font-size: 20px;
  overflow: hidden;
  text-align: center;
  color: #fff;
  margin-right: 20px;
}

.call-consultation .content {
  overflow: auto;
}

.call-consultation .content span {
  font-weight: 500;
  font-size: 15px;
  line-height: 1;
}

.call-consultation .content h5 {
  margin-top: -2px;
}

.consultations-wrapper {
  background-color: #eef4fc;
  background-position: 20px 30px;
  position: relative;
}

.consultations-wrapper::before {
  position: absolute;
  width: 100%;
  height: 130px;
  bottom: 0;
  left: 0;
  content: "";
  background-color: #fff;
  z-index: -1;
}

@media (max-width: 991px) {
  .consultations-wrapper::before {
    height: 100px;
  }
}

@media (max-width: 767px) {
  .consultations-wrapper::before {
    height: 80px;
  }
}

.single-work-process {
  position: relative;
  z-index: 1;
  margin-top: 30px;
  text-align: center;
  padding: 0px 25px;
}

.single-work-process .icon {
  width: 172px;
  height: 172px;
  line-height: 172px;
  text-align: center;
  position: relative;
  color: <?=$ayar['renk']?>;
  font-size: 70px;
  margin: 0 auto;
}

.single-work-process .icon::before {
  -webkit-clip-path: polygon(27% 0, 100% 0, 100% 82%, 79% 100%, 0 100%, 0 19%);
  clip-path: polygon(27% 0, 100% 0, 100% 82%, 79% 100%, 0 100%, 0 19%);
  position: absolute;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
  content: "";
  background-color: #eef5fc;
  z-index: -1;
  -webkit-transform: rotate(25deg);
          transform: rotate(25deg);
}

.single-work-process .icon span {
  position: absolute;
  right: 0;
  top: 0;
  font-size: 16px;
  line-height: 40px;
  width: 40px;
  height: 40px;
  text-align: center;
  background-color: <?=$ayar['renk']?>;
  border-radius: 50%;
  color: #fff;
  display: inline-block;
}

.single-work-process .content {
  margin-top: 40px;
}

.single-work-process .content h3 {
  margin-bottom: 10px;
}

.work-link {
  position: absolute;
  left: 50%;
  top: 40%;
  -webkit-transform: translate(-50%);
          transform: translate(-50%);
  z-index: -1;
}

.team-members-list .single-team-member {
  padding: 0px 30px 30px;
  position: relative;
  z-index: 1;
  border-radius: 7px;
  text-align: center;
  overflow: hidden;
  margin-top: 40px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.team-members-list .single-team-member.style-2 {
  border: 1px solid #efeff1;
  background: transparent;
  padding-top: 30px;
}

.team-members-list .single-team-member.style-2:hover, .team-members-list .single-team-member.style-2.active {
  background: #fff !important;
  border-color: #fff;
  -webkit-box-shadow: 0px 10px 60px 0px rgba(200, 226, 255, 0.45);
          box-shadow: 0px 10px 60px 0px rgba(200, 226, 255, 0.45);
}

.team-members-list .single-team-member.style-2:hover h4, .team-members-list .single-team-member.style-2.active h4 {
  color: <?=$ayar['renk']?>;
}

.team-members-list .single-team-member.style-2:hover p, .team-members-list .single-team-member.style-2.active p {
  color: inherit;
}

.team-members-list .single-team-member.style-2::before {
  display: none;
}

.team-members-list .single-team-member.style-2 .social-profile a {
  border: 1px solid #e6f0fb;
  color: #696969;
  background: #e6f0fb;
  font-weight: 400;
}

.team-members-list .single-team-member.style-2 .social-profile a:hover {
  background: <?=$ayar['renk']?>;
  border-color: <?=$ayar['renk']?>;
  color: #fff;
}

.team-members-list .single-team-member::before {
  position: absolute;
  background-color: #f5f5f5;
  left: 0;
  bottom: 0;
  content: "";
  width: 100%;
  height: 75%;
  border-radius: 7px;
  z-index: -1;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.team-members-list .single-team-member:hover h4, .team-members-list .single-team-member:hover p, .team-members-list .single-team-member.active h4, .team-members-list .single-team-member.active p {
  color: #fff;
}

.team-members-list .single-team-member:hover::before, .team-members-list .single-team-member.active::before {
  background-color: <?=$ayar['renk']?>;
}

.team-members-list .single-team-member .member-img {
  border-radius: 7px;
  width: 210px;
  height: 210px;
  background-color: #eee;
  margin: 0 auto;
  margin-bottom: 20px;
  background-position: center top;
}

.team-members-list .single-team-member .member-bio {
  margin-bottom: 20px;
}

.team-members-list .single-team-member .member-bio h4, .team-members-list .single-team-member .member-bio p {
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.team-members-list .single-team-member .member-bio p {
  line-height: 1;
  margin-top: 5px;
}

.team-members-list .single-team-member .social-profile a {
  display: inline-block;
  border-radius: 50%;
  width: 35px;
  height: 35px;
  line-height: 35px;
  border: 1px solid #84b5eb;
  color: #84b5eb;
  text-align: center;
  font-size: 15px;
  margin: 0 2px;
}

.team-members-list .single-team-member .social-profile a:hover {
  background: #fff;
  color: <?=$ayar['renk']?>;
  border: 1px solid #fff;
}

.member-details-wrap {
  background-color: #f5f5f5;
  padding: 30px;
  border-radius: 7px;
}

.member-details-wrap .sec-title h2 {
  font-size: 28px;
  margin-bottom: 10px;
  line-height: 130%;
  letter-spacing: 0px;
}

.member-details-wrap .member-skills p, .member-details-wrap .member-about p {
  margin-top: 15px;
}

.member-details-wrap .single-contact-info {
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
}

.member-details-wrap .single-contact-info p {
  margin-top: 0;
}

.member-details-wrap .member-card {
  background: #fff;
  border-radius: 7px;
  overflow: hidden;
}

.member-details-wrap .member-card .member-photo {
  border-radius: 7px;
  background-color: <?=$ayar['renk']?>;
  height: 345px;
  background-position: center top;
}

.member-details-wrap .member-card .member-info {
  text-align: center;
  padding: 30px;
}

.member-details-wrap .member-card .member-info .social-link {
  margin-top: 15px;
}

.member-details-wrap .member-card .member-info .social-link a {
  border-radius: 50%;
  width: 34px;
  height: 34px;
  line-height: 36px;
  display: inline-block;
  background-color: <?=$ayar['renk']?>;
  color: #fff;
  text-align: center;
  font-size: 14px;
  font-weight: 400;
  margin: 0 2px;
}

.member-details-wrap .member-card .member-info .social-link a:hover {
  color: <?=$ayar['renk']?>;
  background-color: #ff5e14;
}

.member-contact-info .single-contact-info {
  margin-top: 5px;
}

.member-contact-info .single-contact-info .icon {
  margin-right: 15px;
  color: <?=$ayar['renk']?>;
  font-size: 20px;
}

.single-member-card {
  background-color: #fff;
  -webkit-clip-path: polygon(85% 0, 100% 14%, 100% 100%, 50% 100%, 0 100%, 0 0);
  clip-path: polygon(85% 0, 100% 14%, 100% 100%, 50% 100%, 0 100%, 0 0);
  text-align: center;
  position: relative;
  z-index: 1;
  overflow: hidden;
  margin-top: 30px;
}

.single-member-card:hover .social-profile {
  opacity: 1;
  visibility: visible;
  -webkit-transform: translateY(0);
          transform: translateY(0);
}

.single-member-card:hover .member-bio {
  z-index: -1;
  opacity: 0;
  visibility: hidden;
}

.single-member-card .member-img {
  height: 271px;
  background-color: #fff;
  background-position: top;
}

.single-member-card .member-bio {
  padding: 25px 15px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.single-member-card .social-profile {
  padding: 0 15px;
  padding-bottom: 25px;
  z-index: -1;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
  background-color: #fff;
  position: absolute;
  width: 100%;
  left: 0;
  bottom: 0;
  height: 70px;
  visibility: hidden;
  opacity: 0;
  -webkit-transform: translateY(30px);
          transform: translateY(30px);
}

.single-member-card .social-profile a {
  display: inline-block;
  width: 36px;
  height: 36px;
  line-height: 39px;
  border-radius: 50%;
  background-color: #e8e8eb;
  margin: 0 2px;
  text-align: center;
  font-size: 14px;
  color: #000;
}

.single-member-card .social-profile a:hover {
  background-color: <?=$ayar['renk']?>;
  color: #fff;
}

.funfact-wrapper {
  position: relative;
  z-index: 1;
}

.funfact-wrapper.bottom::before {
  bottom: 0;
  top: auto;
}

.funfact-wrapper.no-bg::before {
  display: none;
}

.funfact-wrapper::before {
  position: absolute;
  height: 50%;
  top: 0;
  left: 0;
  width: 100%;
  background-color: #211e3b;
  content: "";
}

@media (min-width: 1500px) {
  .funfact-wrapper .container {
    max-width: 1400px;
    width: 100%;
  }
}

.funfact-wrapper .funfact-content-grid {
  background-color: <?=$ayar['renk']?>;
  -ms-flex-pack: distribute;
      justify-content: space-around;
}

.funfact-content-grid {
  display: -ms-grid;
  display: grid;
  -ms-grid-columns: 1fr 1fr 1fr 1fr;
      grid-template-columns: 1fr 1fr 1fr 1fr;
  -ms-grid-rows: auto;
      grid-template-rows: auto;
  -webkit-box-pack: justify;
      -ms-flex-pack: justify;
          justify-content: space-between;
  text-align: center;
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
  border-radius: 7px;
  padding: 80px 0px 70px;
}

@media (max-width: 991px) {
  .funfact-content-grid {
    -ms-grid-columns: 1fr 1fr;
        grid-template-columns: 1fr 1fr;
    grid-gap: 40px;
  }
}

@media (max-width: 500px) {
  .funfact-content-grid {
    -ms-grid-columns: 1fr;
        grid-template-columns: 1fr;
    grid-gap: 40px;
  }
}

.funfact-content-grid .single-funfact-item .icon {
  font-size: 42px;
  line-height: 1;
  margin-bottom: 20px;
}

.funfact-content-grid .single-funfact-item h3 {
  font-weight: 500;
  font-size: 55px;
  line-height: 1;
  position: relative;
  display: inline-block;
}



.funfact-content-grid .single-funfact-item h3::before {
  position: absolute;
  content: "+";
  right: -20px;
  top: -15px;
  font-size: 30px;
  font-weight: 400;
}

.funfact-content-grid .single-funfact-item p {
  margin-top: 5px;
}

.our-achivement-fact {
  position: relative;
  margin-top: -100px;
  z-index: -1;
  padding-top: 100px;
}

.our-achivement-fact::after {
  position: absolute;
  width: 100%;
  background-color: #2b2843;
  content: "";
  height: 100%;
  left: 0;
  bottom: 0;
  z-index: -1;
  opacity: .5;
}

.work-process-grid {
  display: -ms-grid;
  display: grid;
  -ms-grid-columns: 1fr 1fr 1fr 1fr;
      grid-template-columns: 1fr 1fr 1fr 1fr;
  -ms-grid-rows: auto;
      grid-template-rows: auto;
  grid-gap: 80px;
  position: relative;
}

@media (max-width: 1199px) {
  .work-process-grid {
    -ms-grid-columns: 1fr 1fr;
        grid-template-columns: 1fr 1fr;
    grid-gap: 80px;
  }
}

@media (max-width: 767px) {
  .work-process-grid {
    -ms-grid-columns: 1fr;
        grid-template-columns: 1fr;
    grid-gap: 30px;
  }
}

.work-process-grid::after {
  background-image: url("../img/work-process-line.png");
  width: 1543px;
  height: 154px;
  position: absolute;
  left: 50%;
  -webkit-transform: translateX(-50%);
          transform: translateX(-50%);
  top: 30%;
  content: "";
  background-repeat: no-repeat;
  z-index: -1;
}

@media (max-width: 1600px) {
  .work-process-grid::after {
    display: none;
  }
}

.work-process-grid .single-work-process {
  text-align: center;
  margin-top: 30px;
  position: relative;
  z-index: 1;
}

.work-process-grid .single-work-process:nth-child(2), .work-process-grid .single-work-process:nth-child(4) {
  margin-top: 90px;
}

@media (max-width: 1400px) {
  .work-process-grid .single-work-process:nth-child(2), .work-process-grid .single-work-process:nth-child(4) {
    margin-top: 30px;
  }
}

.work-process-grid .single-work-process:nth-child(4) {
  margin-top: 60px;
}

@media (max-width: 1400px) {
  .work-process-grid .single-work-process:nth-child(4) {
    margin-top: 30px;
  }
}

.work-process-grid .single-work-process:hover .icon {
  background-color: <?=$ayar['renk']?>;
  color: #fff;
}

.work-process-grid .single-work-process .icon {
  border-radius: 50%;
  width: 115px;
  height: 115px;
  border: 10px solid #fff;
  background-color: #e6f0fb;
  color: <?=$ayar['renk']?>;
  line-height: 100px;
  font-size: 50px;
  -webkit-box-sizing: border-box;
          box-sizing: border-box;
  margin: 0 auto;
  margin-bottom: 25px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.work-process-grid .single-work-process .icon:hover {
  background-color: <?=$ayar['renk']?>;
  color: #fff;
}

.work-process-grid .single-work-process .content h3 {
  margin-bottom: 10px;
}

.work-process-grid .single-work-process .content p {
  font-size: 16px;
}

.work-process-grid .single-work-process .content span {
  display: inline-block;
  border: 2px solid #dbe0ea;
  border-radius: 50%;
  width: 36px;
  height: 36px;
  line-height: 32px;
  background: transparent;
  margin: 0 auto;
  margin-top: 15px;
}

.single-skill-bar {
  margin-top: 35px;
}

.single-skill-bar .d-flex {
  margin-bottom: 10px;
}

.single-skill-bar .d-flex span {
  color: #211e3b;
  font-weight: 700;
}

.single-skill-bar .progress {
  height: 3px;
}

.single-skill-bar .progress .progress-bar {
  background-color: <?=$ayar['renk']?>;
}

.skill-banner {
  position: relative;
}

.skill-banner .skill-popup-video {
  border-width: 10px;
  border-color: white;
  border-style: solid;
  border-radius: 50%;
  background-color: #bfbfbf;
  -webkit-box-shadow: 0px 10px 60px 0px rgba(22, 37, 66, 0.4);
          box-shadow: 0px 10px 60px 0px rgba(22, 37, 66, 0.4);
  width: 190px;
  height: 190px;
  z-index: 2;
  position: absolute;
  bottom: 60px;
  left: 0;
  -webkit-transform: translateX(-50%);
          transform: translateX(-50%);
}

@media (max-width: 991px) {
  .skill-banner .skill-popup-video {
    right: 0;
    left: auto;
  }
}

@media (max-width: 767px) {
  .skill-banner .skill-popup-video {
    right: 0;
    left: auto;
    -webkit-transform: translateX(20%);
            transform: translateX(20%);
  }
}

@media (max-width: 600px) {
  .skill-banner .skill-popup-video {
    right: 0;
    left: auto;
    -webkit-transform: translateX(0%);
            transform: translateX(0%);
  }
}

.skill-banner .skill-popup-video::before {
  position: absolute;
  width: 100%;
  height: 100%;
  content: "";
  background: #211e3b;
  border-radius: 50%;
  left: 0;
  top: 0;
  opacity: .70;
  z-index: -1;
}

.skill-banner .skill-popup-video .video-play-btn {
  width: 50px;
  height: 50px;
  text-align: center;
  background-color: <?=$ayar['renk']?>;
  color: #fff;
  border-radius: 50%;
  line-height: 54px;
}

.skill-banner .skill-popup-video .video-play-btn a {
  color: #fff;
  line-height: 1;
}

.funfact-box-bg {
  width: 100%;
  background-color: <?=$ayar['renk']?>;
  border-radius: 7px;
  margin: 0px auto;
  padding: 80px 0px;
}

@media (min-width: 1450px) {
  .funfact-box-bg {
    max-width: 1400px;
  }
}

.fun-fact-grid {
  display: -ms-grid;
  display: grid;
  -ms-grid-columns: 1fr 1fr;
      grid-template-columns: 1fr 1fr;
  -ms-grid-rows: auto;
      grid-template-rows: auto;
  grid-gap: 30px;
  text-align: center;
}

@media (max-width: 500px) {
  .fun-fact-grid {
    -ms-grid-columns: 1fr;
        grid-template-columns: 1fr;
  }
}

.fun-fact-grid .single-funfact-item {
  background-color: #fff;
  padding: 40px 30px 30px;
  -webkit-clip-path: polygon(13% 0, 100% 0, 100% 100%, 52% 100%, 0 100%, 0 14%);
  clip-path: polygon(13% 0, 100% 0, 100% 100%, 52% 100%, 0 100%, 0 14%);
}

.fun-fact-grid .single-funfact-item .icon {
  font-size: 55px;
  margin-bottom: 10px;
  color: <?=$ayar['renk']?>;
}

.fun-fact-grid .single-funfact-item h3 {
  font-size: 55px;
  line-height: 1;
}

.brand-carousel-active {
  border-top: 1px solid #e8e8eb;
}

.client-brand-wrap .single-client img {
  -webkit-filter: brightness(10);
          filter: brightness(10);
}

.faq-section {
  position: relative;
  background-color: #f8f8f8;
}

.faq-bg {
  position: absolute;
  left: 0;
  top: 0;
  width: 50%;
  height: 100%;
  content: "";
  background-color: #eee;
}

.accordion {
  color: #777;
}

.accordion .card {
  margin-top: 15px;
  border: none;
  border-radius: 7px !important;
}

.accordion .card-header {
  padding: 0px 28px;
  border: none;
  background-color: transparent;
}

@media (max-width: 480px) {
  .accordion .card-header {
    padding: 0 15px;
  }
}

.accordion .card-header a {
  display: block;
  font-weight: 600;
  line-height: 50px;
  padding: 10px 0px;
  position: relative;
  color: #000;
  font-size: 18px;
}

.accordion .card-header a:after {
  content: "\f067";
  font-family: "Font Awesome 5 Pro";
  position: absolute;
  right: 0;
  top: 50%;
  font-weight: 700;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  color: <?=$ayar['renk']?>;
}

.accordion .card-header a[aria-expanded="true"]:after {
  content: "\f068";
  /* <i class="fal fa-angle-up"></i> */
}

@media (max-width: 767px) {
  .accordion .card-header a {
    line-height: 40px;
    font-size: 15px;
  }
}

.accordion .card-header a:hover {
  color: <?=$ayar['renk']?>;
}

.accordion .card-body {
  padding-left: 28px;
  padding-top: 10px;
  padding-bottom: 30px;
}

.single-faq-card {
  text-align: center;
  position: relative;
  z-index: 1;
  padding: 60px 45px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

@media (max-width: 991px) {
  .single-faq-card {
    margin-bottom: 40px;
  }
}

.single-faq-card::before {
  position: absolute;
  width: 100%;
  height: 100%;
  content: "";
  background: #000;
  opacity: .6;
  z-index: -1;
  left: 0;
  top: 0;
}

.single-faq-card .icon {
  width: 120px;
  height: 120px;
  line-height: 120px;
  margin: 0 auto;
  display: inline-block;
  background-color: #fff;
  border-radius: 50%;
  text-align: center;
  margin-bottom: 30px;
}

.single-faq-card h3 {
  color: #fff;
  margin-bottom: 10px;
}

.single-faq-card p {
  color: #b1b5b7;
}

.single-faq-card a {
  width: 60px;
  height: 60px;
  line-height: 60px;
  margin: 0 auto;
  display: inline-block;
  background-color: #00baa3;
  border-radius: 50%;
  text-align: center;
  margin-top: 20px;
  color: #fff;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.single-faq-card a:hover {
  color: #00baa3;
  background: #fff;
}

.single-faq-card.card2 a {
  background-color: #d55342;
}

.single-faq-card.card2 a:hover {
  color: #d55342;
  background: #fff;
}

.single-faq-card.card3 a {
  background-color: #efc94c;
}

.single-faq-card.card3 a:hover {
  color: #efc94c;
  background: #fff;
}

.single-blog-card {
  background-color: #fff;
  border-radius: 7px;
  padding: 20px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
  margin-top: 40px;
}

@media (max-width: 991px) {
  .single-blog-card {
    margin-top: 30px;
  }
}

.single-blog-card:hover, .single-blog-card.active {
  background-color: #fff;
  -webkit-box-shadow: 0px 10px 60px 0px rgba(200, 226, 255, 0.45);
          box-shadow: 0px 10px 60px 0px rgba(200, 226, 255, 0.45);
}

.single-blog-card.style-2 {
  -webkit-box-shadow: 0px 10px 60px 0px rgba(200, 226, 255, 0.45);
          box-shadow: 0px 10px 60px 0px rgba(200, 226, 255, 0.45);
  background-color: #fff;
  padding: 0;
}

.single-blog-card .blog-featured-thumb {
  border-radius: 7px;
  background-color: #eee;
  height: 210px;
}

.single-blog-card .content {
  padding: 30px;
  padding-bottom: 40px;
}

.single-blog-card .content .post-author a {
  color: #696969;
}

.single-blog-card .content h3 {
  font-size: 20px;
  font-weight: 700;
  margin-top: 10px;
}

.single-blog-card .content .btn-link-share {
  margin-top: 20px;
}

.single-blog-card .content .btn-link-share .theme-btn.minimal-btn {
  font-size: 14px;
  line-height: 1;
  color: #696969;
  border: 1px solid #e8e8eb;
  padding: 20px 30px;
}

.single-blog-card .content .btn-link-share .theme-btn.minimal-btn:hover {
  background-color: <?=$ayar['renk']?>;
  color: #fff;
  border: 1px solid <?=$ayar['renk']?>;
}

.single-blog-card .content .btn-link-share a:last-child {
  color: #696969;
  margin-left: 20px;
  font-size: 20px;
}

.single-blog-card .content .btn-link-share a:last-child:hover {
  color: <?=$ayar['renk']?>;
}

.single-news-card {
  position: relative;
  margin-top: 30px;
}

.single-news-card .blog-featured-thumb {
  height: 350px;
  background-color: #eee;
  position: relative;
  -webkit-clip-path: polygon(13% 0, 100% 0, 100% 100%, 52% 100%, 0 100%, 0 14%);
  clip-path: polygon(13% 0, 100% 0, 100% 100%, 52% 100%, 0 100%, 0 14%);
}

.single-news-card .blog-featured-thumb .date {
  display: inline-block;
  padding: 15px;
  background-color: <?=$ayar['renk']?>;
  color: #fff;
  line-height: 1;
  text-align: center;
  position: absolute;
  right: 15px;
  top: 15px;
}

.single-news-card .blog-featured-thumb .date span {
  font-weight: 500;
  font-size: 25px;
  display: block;
  margin-bottom: 3px;
}

.single-news-card .content {
  padding: 30px;
  padding-bottom: 40px;
  border: 1px solid #f8f8f8;
  border-top: 0px;
}

.single-news-card .content .post-author a {
  color: #696969;
}

.single-news-card .content h3 {
  font-size: 20px;
  font-weight: 700;
  margin-top: 10px;
}

.single-news-card .content .btn-link-share {
  margin-top: 20px;
}

.single-news-card .content .btn-link-share .theme-btn.off-white {
  font-size: 14px;
  line-height: 1;
  color: #696969;
  border: 1px solid #e8e8eb;
  padding: 20px 30px;
}

.single-news-card .content .btn-link-share .theme-btn.off-white:hover {
  background-color: <?=$ayar['renk']?>;
  color: #fff;
  border: 1px solid <?=$ayar['renk']?>;
}

.blog-wrapper .border-wrap {
  padding: 50px;
}

@media (max-width: 767px) {
  .blog-wrapper .border-wrap {
    padding: 50px 15px;
  }
}

.blog-wrapper .border-wrap .single-blog-post .post-content {
  padding: 0px;
}

.blog-wrapper .single-blog-post {
  margin-bottom: 40px;
  position: relative;
}

.blog-wrapper .single-blog-post.post-details .post-content {
  border: none;
}

.blog-wrapper .single-blog-post.post-details .post-content img {
  margin-top: 20px;
  margin-bottom: 20px;
}

.blog-wrapper .single-blog-post.post-details .post-content h1 {
  font-size: 36px;
  line-height: 1.4;
}

@media (max-width: 767px) {
  .blog-wrapper .single-blog-post.post-details .post-content h1 {
    font-size: 28px;
  }
  .blog-wrapper .single-blog-post.post-details .post-content h3 {
    font-size: 20px;
  }
}

.blog-wrapper .single-blog-post.post-details blockquote, .blog-wrapper .single-blog-post.post-details .wp-block-quote {
  background-color: #211e3b;
  color: #fff;
  font-size: 26px;
  line-height: 1.4;
  font-family: "Circular Std", sans-serif;
  font-weight: 400;
  padding: 60px;
  text-align: left;
  margin: 40px 0px;
  position: relative;
  z-index: 1;
}

@media (max-width: 767px) {
  .blog-wrapper .single-blog-post.post-details blockquote, .blog-wrapper .single-blog-post.post-details .wp-block-quote {
    padding: 30px 15px;
    font-size: 18px;
    line-height: 1.5;
  }
}

.blog-wrapper .single-blog-post.post-details blockquote::before, .blog-wrapper .single-blog-post.post-details .wp-block-quote::before {
  right: 30px;
  font-size: 110px;
  line-height: 1;
  font-family: "Font Awesome 5 Pro";
  position: absolute;
  content: "\f10d";
  bottom: -20px;
  color: #fff;
  z-index: -1;
  opacity: .1;
  font-weight: 900;
}

.blog-wrapper .single-blog-post.format-video .post-featured-thumb, .blog-wrapper .single-blog-post.category-video-post .post-featured-thumb {
  z-index: 1;
}

.blog-wrapper .single-blog-post.format-video .post-featured-thumb::before, .blog-wrapper .single-blog-post.category-video-post .post-featured-thumb::before {
  position: absolute;
  width: 100%;
  height: 100%;
  left: 0;
  top: 0;
  content: "";
  background-color: #282835;
  opacity: .3;
  z-index: -1;
}

.blog-wrapper .single-blog-post.quote-post .post-content, .blog-wrapper .single-blog-post.format-quote .post-content {
  position: relative;
  background-color: <?=$ayar['renk']?>;
  background-image: url("../img/quotepost.png");
}

.blog-wrapper .single-blog-post.quote-post .quote-content, .blog-wrapper .single-blog-post.format-quote .quote-content {
  overflow: hidden;
}

@media (max-width: 585px) {
  .blog-wrapper .single-blog-post.quote-post .quote-content, .blog-wrapper .single-blog-post.format-quote .quote-content {
    text-align: center;
    font-size: 24px;
  }
}

.blog-wrapper .single-blog-post.quote-post .quote-content .icon, .blog-wrapper .single-blog-post.format-quote .quote-content .icon {
  font-size: 76px;
  line-height: 80px;
  float: left;
  overflow: hidden;
  margin-right: 30px;
}

@media (max-width: 585px) {
  .blog-wrapper .single-blog-post.quote-post .quote-content .icon, .blog-wrapper .single-blog-post.format-quote .quote-content .icon {
    float: none;
    margin-bottom: 10px;
    margin-right: 0;
    font-size: 50px;
    line-height: 60px;
  }
}

.blog-wrapper .single-blog-post.quote-post .quote-content .quote-text, .blog-wrapper .single-blog-post.format-quote .quote-content .quote-text {
  overflow: hidden;
}

.blog-wrapper .single-blog-post.quote-post .quote-content h2, .blog-wrapper .single-blog-post.format-quote .quote-content h2 {
  margin-top: -2px;
}

.blog-wrapper .single-blog-post:last-child {
  margin-bottom: 0;
}

.blog-wrapper .single-blog-post .post-featured-thumb {
  height: 460px;
  width: 100%;
  position: relative;
  background-color: #f2f2f2;
}

@media (max-width: 991px) {
  .blog-wrapper .single-blog-post .post-featured-thumb {
    height: 350px;
  }
}

@media (max-width: 767px) {
  .blog-wrapper .single-blog-post .post-featured-thumb {
    height: 280px;
  }
}

.blog-wrapper .single-blog-post .post-featured-thumb .video-play-btn {
  position: absolute;
  left: 50%;
  top: 50%;
  -webkit-transform: translate(-50%, -50%);
          transform: translate(-50%, -50%);
  z-index: 2;
}

.blog-wrapper .single-blog-post .post-featured-thumb .video-play-btn .play-video {
  border-radius: 50%;
  width: 80px;
  height: 80px;
  line-height: 80px;
  font-size: 18px;
}

.blog-wrapper .single-blog-post .post-content {
  padding: 50px;
  border: 2px solid #ededed;
  border-top: 0px;
  overflow: hidden;
}

@media (max-width: 767px) {
  .blog-wrapper .single-blog-post .post-content {
    padding: 50px 10px;
  }
  .blog-wrapper .single-blog-post .post-content h2 {
    font-size: 26px;
    line-height: 1.4;
  }
}

@media (max-width: 414px) {
  .blog-wrapper .single-blog-post .post-content h2 {
    font-size: 22px;
  }
}

.blog-wrapper .single-blog-post .post-content .post-cat a {
  color: #fff;
  display: inline-block;
  background-color: <?=$ayar['renk']?>;
  padding: 9px 18px;
  line-height: 1;
  font-size: 14px;
  font-weight: 700;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
  margin-bottom: 20px;
}

@media (max-width: 767px) {
  .blog-wrapper .single-blog-post .post-content .post-cat a {
    font-size: 12px;
  }
}

.blog-wrapper .single-blog-post .post-content .post-cat a:hover {
  background-color: #211e3b;
}

.blog-wrapper .single-blog-post .post-content ul {
  margin-bottom: 20px;
  margin-top: 15px;
}

@media (max-width: 767px) {
  .blog-wrapper .single-blog-post .post-content ul {
    margin-left: 0;
  }
}

.blog-wrapper .single-blog-post .post-content ul li {
  font-size: 16px;
  color: #727475;
  font-weight: 700;
  margin-top: 10px;
  padding-left: 30px;
  display: block;
}

.blog-wrapper .single-blog-post .post-content ul li::before {
  position: absolute;
  top: 0;
  left: 0;
  content: "\f00c";
  font-family: "Font Awesome 5 Pro";
  font-weight: 400;
  color: #222;
}

.blog-wrapper .single-blog-post .post-content p {
  margin-top: 15px;
}

.blog-wrapper .single-blog-post .post-content .post-meta {
  margin-top: 10px;
}

.blog-wrapper .single-blog-post .post-content .post-meta span {
  color: #202426;
  font-weight: 700;
  font-size: 14px;
  line-height: 1;
  display: inline-block;
  margin-right: 25px;
}

@media (max-width: 767px) {
  .blog-wrapper .single-blog-post .post-content .post-meta span {
    font-size: 13px;
  }
}

.blog-wrapper .single-blog-post .post-content .post-meta span i {
  margin-right: 5px;
}

.blog-wrapper .single-blog-post .post-content .author-info {
  overflow: hidden;
}

.blog-wrapper .single-blog-post .post-content .author-info .author-img {
  height: 40px;
  width: 40px;
  line-height: 40px;
  border-radius: 50%;
  background-color: #f2f2f2;
  margin-right: 15px;
  float: left;
  overflow: hidden;
  background-position: center;
  background-size: cover;
}

@media (max-width: 767px) {
  .blog-wrapper .single-blog-post .post-content .author-info .author-img {
    margin-right: 5px;
  }
}

.blog-wrapper .single-blog-post .post-content .author-info h5 {
  display: inline-block;
  line-height: 1;
  font-size: 16px;
  margin-top: 9px;
}

@media (max-width: 767px) {
  .blog-wrapper .single-blog-post .post-content .author-info h5 {
    font-size: 14px;
  }
}

.blog-wrapper .single-blog-post .post-content .post-link a {
  font-weight: 700;
}

@media (max-width: 767px) {
  .blog-wrapper .single-blog-post .post-content .post-link a {
    font-size: 14px;
  }
}

.blog-wrapper .single-blog-post .post-content .post-link a i {
  margin-right: 5px;
}

@media (max-width: 767px) {
  .blog-wrapper .single-blog-post .post-content .post-link a i {
    margin-right: 3px;
  }
}

@media (min-width: 991px) {
  .main-sidebar {
    margin-left: 20px;
  }
}

@media (max-width: 991px) {
  .main-sidebar {
    margin-top: 40px;
  }
}

.main-sidebar .single-sidebar-widget {
  border: 2px solid #ededed;
  -webkit-box-sizing: border-box;
          box-sizing: border-box;
  padding: 40px;
  margin-bottom: 40px;
}

.main-sidebar .single-sidebar-widget:last-child {
  margin-bottom: 0;
}

.main-sidebar .single-sidebar-widget .wid-title {
  margin-bottom: 35px;
  position: relative;
  padding-left: 45px;
}

.main-sidebar .single-sidebar-widget .wid-title::before {
  left: 0;
  top: 50%;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  content: "";
  height: 4px;
  width: 18px;
  border-radius: 5px;
  position: absolute;
  background-color: <?=$ayar['renk']?>;
}

.main-sidebar .single-sidebar-widget .wid-title::after {
  left: 22px;
  top: 50%;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  content: "";
  height: 4px;
  width: 4px;
  border-radius: 50%;
  position: absolute;
  background-color: <?=$ayar['renk']?>;
}

.main-sidebar .single-sidebar-widget .social-link a {
  display: inline-block;
  width: 40px;
  height: 40px;
  line-height: 40px;
  text-align: center;
  border-radius: 50%;
  background-color: #f2f2f2;
  font-size: 14px;
  margin-right: 5px;
  margin-bottom: 5px;
}

.main-sidebar .single-sidebar-widget .social-link a:hover {
  background-color: <?=$ayar['renk']?>;
  color: #fff;
}

.main-sidebar .author-box-widegts .author-img {
  width: 140px;
  height: 140px;
  line-height: 140px;
  background-color: #f2f2f2;
  border-radius: 50%;
  margin: 0 auto;
  display: inline-block;
  margin-bottom: 15px;
}

.main-sidebar .author-box-widegts p {
  font-size: 14px;
  margin-top: 10px;
}

.main-sidebar .author-box-widegts .social-profile {
  margin-top: 15px;
}

.main-sidebar .author-box-widegts .social-profile a {
  display: inline-block;
  margin-top: 10px;
  margin-right: 10px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.main-sidebar .author-box-widegts .social-profile a:hover {
  color: <?=$ayar['renk']?>;
}

.search_widget form {
  width: 100%;
  position: relative;
}

.search_widget form input {
  background-color: #f8f8f8;
  font-size: 15px;
  padding: 20px;
  width: 100%;
}

.search_widget form button {
  position: absolute;
  right: 0;
  top: 0;
  width: 70px;
  font-size: 18px;
  height: 100%;
  background-color: <?=$ayar['renk']?>;
  color: #fff;
  text-align: center;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.search_widget form button:hover {
  background-color: #211e3b;
}

.instagram-gallery, .instagram_gallery {
  width: 100%;
  overflow: hidden;
  margin-left: -5px;
}

.instagram-gallery .single-photo-item, .instagram_gallery .single-photo-item {
  float: left;
  margin-left: 4%;
  background-color: #f8f8f8;
  height: 80px;
  width: 29%;
  overflow: hidden;
  margin-bottom: 10px;
}

.popular-posts .single-post-item, .popular_posts .single-post-item {
  overflow: hidden;
  padding-bottom: 30px;
  margin-bottom: 30px;
  border-bottom: 1px solid #f2f2f2;
}

.popular-posts .single-post-item:last-child, .popular_posts .single-post-item:last-child {
  margin-bottom: 0;
  border: none;
  padding-bottom: 0;
}

.popular-posts .single-post-item .thumb, .popular_posts .single-post-item .thumb {
  width: 80px;
  height: 80px;
  border-radius: 50%;
  background-color: #f2f2f2;
  float: left;
  overflow: hidden;
  margin-right: 20px;
}

.popular-posts .single-post-item .post-content, .popular_posts .single-post-item .post-content {
  overflow: hidden;
}

.popular-posts .single-post-item .post-content h5, .popular_posts .single-post-item .post-content h5 {
  font-size: 16px;
  line-height: 22px;
}

.popular-posts .single-post-item .post-content h5:hover, .popular_posts .single-post-item .post-content h5:hover {
  color: <?=$ayar['renk']?>;
}

.popular-posts .single-post-item .post-content .post-date, .popular_posts .single-post-item .post-content .post-date {
  margin-top: 5px;
  font-weight: 700;
  font-size: 14px;
}

.popular-posts .single-post-item .post-content .post-date i, .popular_posts .single-post-item .post-content .post-date i {
  margin-right: 7px;
}

.tagcloud a {
  display: inline-block;
  padding: 11px 26px;
  line-height: 1;
  font-size: 14px;
  font-weight: 700;
  background: #f8f8f8;
  margin-right: 5px;
  margin-bottom: 8px;
}

.tagcloud a:last-child {
  margin-right: 0;
}

.tagcloud a:hover {
  background-color: <?=$ayar['renk']?>;
  color: #fff;
}

.widget_categories ul li {
  display: block;
}

.widget_categories ul li:last-child a {
  margin-bottom: 0;
}

.widget_categories ul li a {
  position: relative;
  background: #f8f8f8;
  padding: 20px 30px;
  line-height: 1;
  font-size: 14px;
  font-weight: 700;
  display: block;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
  margin-bottom: 10px;
}

.widget_categories ul li a:hover {
  color: #ff5e14;
}

.widget_categories ul li a span {
  position: absolute;
  width: 60px;
  line-height: 53px;
  height: 100%;
  content: "";
  background-color: #e3e3e3;
  right: 0;
  top: 0;
  text-align: center;
}

.causes-page-nav ul li, .page-nav-wrap ul li {
  display: inline-block;
}

.causes-page-nav ul li a, .page-nav-wrap ul li a {
  display: inline-block;
  width: 60px;
  height: 60px;
  line-height: 60px;
  border-radius: 50%;
  background: #f6f6f6;
  font-weight: 700;
  -webkit-transition: all 0.3s ease-in-out;
  transition: all 0.3s ease-in-out;
  margin: 0 2px;
}

@media (max-width: 767px) {
  .causes-page-nav ul li a, .page-nav-wrap ul li a {
    margin-top: 10px;
    width: 50px;
    height: 50px;
    line-height: 50px;
    font-size: 14px;
  }
}

.causes-page-nav ul li a i, .page-nav-wrap ul li a i {
  margin-top: 2px;
}

.causes-page-nav ul li a:hover, .page-nav-wrap ul li a:hover {
  background-color: <?=$ayar['renk']?>;
  color: #fff;
}

.social-share a {
  margin-left: 10px;
}

.tag-share-wrap {
  padding-bottom: 50px;
}

.tag-share-wrap h4 {
  margin-bottom: 25px;
}

@media (max-width: 767px) {
  .tag-share-wrap h4 {
    margin-bottom: 10px;
    font-size: 18px;
  }
}

@media (max-width: 767px) {
  .tag-share-wrap .tagcloud {
    margin-bottom: 20px;
  }
}

.related-post-wrap, .related_posts_wrap {
  border-top: 1px solid #e2e2e2;
  padding-top: 40px;
}

.related-post-wrap .single-related-post, .related_posts_wrap .single-related-post {
  margin-top: 33px;
  -webkit-box-shadow: 0px 8px 16px 0px rgba(93, 93, 93, 0.06);
          box-shadow: 0px 8px 16px 0px rgba(93, 93, 93, 0.06);
}

.related-post-wrap .single-related-post:hover h4, .related_posts_wrap .single-related-post:hover h4 {
  color: #ff5e14;
}

.related-post-wrap .single-related-post .featured-thumb, .related_posts_wrap .single-related-post .featured-thumb {
  height: 280px;
  background-color: #f8f8f8;
}

@media (max-width: 767px) {
  .related-post-wrap .single-related-post .featured-thumb, .related_posts_wrap .single-related-post .featured-thumb {
    height: 200px;
  }
}

.related-post-wrap .single-related-post .post-content, .related_posts_wrap .single-related-post .post-content {
  padding: 35px;
}

@media (max-width: 767px) {
  .related-post-wrap .single-related-post .post-content, .related_posts_wrap .single-related-post .post-content {
    padding: 30px 15px;
  }
}

.related-post-wrap .single-related-post .post-content .post-date, .related_posts_wrap .single-related-post .post-content .post-date {
  font-weight: 700;
  margin-bottom: 5px;
  font-size: 14px;
  color: #202426;
}

.related-post-wrap .single-related-post .post-content .post-date i, .related_posts_wrap .single-related-post .post-content .post-date i {
  margin-right: 6px;
}

.related-post-wrap .single-related-post .post-content h4, .related_posts_wrap .single-related-post .post-content h4 {
  margin-bottom: 15px;
}

@media (max-width: 767px) {
  .related-post-wrap .single-related-post .post-content h4, .related_posts_wrap .single-related-post .post-content h4 {
    font-size: 18px;
  }
}

.related-post-wrap .single-related-post .post-content p, .related_posts_wrap .single-related-post .post-content p {
  font-size: 15px;
  line-height: 26px;
  color: #727475;
}

.comments-section-wrap {
  overflow: hidden;
}

.comments-heading h3, .related-post-wrap h3, .comment-form-wrap h3 {
  font-size: 26px;
}

@media (max-width: 767px) {
  .comments-heading h3, .related-post-wrap h3, .comment-form-wrap h3 {
    font-size: 20px;
  }
}

.comments-item-list .replay-comment {
  margin-left: 100px;
}

@media (max-width: 767px) {
  .comments-item-list .replay-comment {
    margin-left: 15px;
  }
}

.comments-item-list .single-comment-item {
  margin-top: 30px;
}

.comments-item-list .single-comment-item .author-img {
  width: 100px;
  height: 100px;
  border-radius: 50%;
  float: left;
  overflow: hidden;
  margin-right: 30px;
}

@media (max-width: 585px) {
  .comments-item-list .single-comment-item .author-img {
    float: none;
    margin-bottom: 20px;
  }
}

.comments-item-list .single-comment-item .author-info-comment {
  overflow: auto;
  padding-bottom: 25px;
  border-bottom: 1px solid #e2e2e2;
}

.comments-item-list .single-comment-item .author-info-comment .info {
  position: relative;
}

@media (max-width: 767px) {
  .comments-item-list .single-comment-item .author-info-comment .info h5 {
    font-size: 16px;
  }
}

.comments-item-list .single-comment-item .author-info-comment span {
  color: <?=$ayar['renk']?>;
}

.comments-item-list .single-comment-item .author-info-comment .theme-btn {
  padding: 10px 18px;
  font-size: 14px;
  position: absolute;
  top: 50%;
  right: 0;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
  color: #000;
}

@media (max-width: 767px) {
  .comments-item-list .single-comment-item .author-info-comment .theme-btn {
    font-size: 12px;
  }
}

.comments-item-list .single-comment-item .author-info-comment .theme-btn i {
  margin-right: 5px;
  margin-left: 0;
}

.comments-item-list .single-comment-item .author-info-comment .comment-text {
  margin-top: 15px;
}

.comment-form {
  background-color: #f0f0f0;
  padding: 50px;
  width: 100%;
  margin-top: 30px;
}

@media (max-width: 767px) {
  .comment-form {
    padding: 30px;
  }
}

@media (max-width: 585px) {
  .comment-form {
    padding: 30px 15px;
  }
}

.comment-form input, .comment-form textarea {
  margin-bottom: 20px;
  padding: 24px 30px;
  line-height: 1;
  font-size: 14px;
  width: 100%;
}

@media (max-width: 585px) {
  .comment-form input, .comment-form textarea {
    padding: 15px;
  }
}

.comment-form textarea {
  height: 200px;
}

@media (max-width: 767px) {
  .comment-form textarea {
    height: 120px;
  }
}

.comment-form .submit-btn {
  display: inline-block;
  background-color: <?=$ayar['renk']?>;
  color: #fff;
  line-height: 1;
  font-size: 700;
  text-transform: capitalize;
  padding: 24px 60px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

@media (max-width: 767px) {
  .comment-form .submit-btn {
    padding: 20px 40px;
  }
}

@media (max-width: 585px) {
  .comment-form .submit-btn {
    padding: 15px 40px;
    font-size: 14px;
  }
}

.comment-form .submit-btn:hover {
  background-color: #211e3b;
}

.comment-form .submit-btn i {
  margin-right: 10px;
}

.border-wrap {
  border: 2px solid #ededed;
}

/* ----------------------------------
	Contact Us Section Styles
 ------------------------------------ */
.contact-form {
  padding-top: 40px;
}

@media (max-width: 585px) {
  .contact-form {
    padding-top: 20px;
  }
}

.contact-form .single-personal-info {
  margin-bottom: 20px;
}

.contact-form input, .contact-form textarea {
  width: 100%;
  background: #f8f8f8;
  line-height: 1;
  padding: 25px 30px;
  border: 0px;
  border-radius: 7px;
}

@media (max-width: 585px) {
  .contact-form input, .contact-form textarea {
    padding: 15px;
    font-size: 13px;
  }
}

.contact-form textarea {
  height: 220px;
}

@media (max-width: 767px) {
  .contact-form textarea {
    height: 160px;
  }
}

.contact-form label {
  color: #202426;
  font-weight: 700;
  font-size: 14px;
  margin-bottom: 10px;
  text-transform: capitalize;
}

.contact-form label span {
  color: #727475;
  margin-left: 5px;
}

.contact-form input[type='submit'], .contact-form .submit-btn {
  background: <?=$ayar['renk']?>;
  color: #fff;
  font-weight: 700;
  line-height: 1;
  padding: 25px 40px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
  width: 280px;
}

.contact-form input[type='submit'].active, .contact-form input[type='submit']:hover, .contact-form .submit-btn.active, .contact-form .submit-btn:hover {
  background-color: #ff5e14;
}

.contact-form input[type='submit'] i, .contact-form .submit-btn i {
  margin-right: 8px;
}

@media (max-width: 400px) {
  .contact-form input[type='submit'], .contact-form .submit-btn {
    width: 100%;
  }
}

.single-contact-card {
  background-color: #f8f8f8;
  padding: 40px;
  margin-bottom: 30px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

@media (max-width: 585px) {
  .single-contact-card {
    padding: 30px;
  }
}

.single-contact-card:hover {
  background-color: #202426;
}

.single-contact-card:hover .icon {
  color: #fff !important;
  background-color: <?=$ayar['renk']?> !important;
}

.single-contact-card:hover .bottom-part .icon {
  color: <?=$ayar['renk']?> !important;
  background-color: #fff !important;
}

.single-contact-card:hover p, .single-contact-card:hover span {
  color: #c5c7c8;
}

.single-contact-card:hover h4 {
  color: #fff;
}

.single-contact-card .top-part {
  overflow: hidden;
}

.single-contact-card .top-part .icon {
  width: 70px;
  height: 70px;
  font-size: 20px;
  line-height: 70px;
  border-radius: 50%;
  background-color: #fff;
  text-align: center;
  float: left;
  color: <?=$ayar['renk']?>;
  overflow: hidden;
  margin-right: 20px;
}

.single-contact-card .top-part .title {
  overflow: hidden;
}

.single-contact-card .bottom-part {
  margin-top: 25px;
  overflow: hidden;
}

.single-contact-card .bottom-part .icon {
  width: 50px;
  height: 50px;
  font-size: 14px;
  line-height: 50px;
  border-radius: 50%;
  background-color: #fff;
  text-align: center;
  float: right;
  overflow: hidden;
  margin-left: 20px;
}

.single-contact-card .bottom-part .info {
  display: inline-block;
  overflow: hidden;
}

.contact-map-wrap iframe {
  height: 450px;
}

@media (max-width: 991px) {
  .contact-map-wrap iframe {
    height: 300px;
  }
}

.consultations-form {
  background-color: <?=$ayar['renk']?>;
  padding: 70px 65px;
  border-radius: 7px;
}

@media (max-width: 991px) {
  .consultations-form {
    padding: 60px 50px;
  }
}

@media (max-width: 767px) {
  .consultations-form {
    padding: 40px 30px;
  }
}

.consultations-form.style-2 {
  position: relative;
  z-index: 99;
  margin-top: -190px;
  -webkit-box-shadow: 0px 10px 60px 0px rgba(8, 106, 215, 0.1);
          box-shadow: 0px 10px 60px 0px rgba(8, 106, 215, 0.1);
}

@media (max-width: 1199px) {
  .consultations-form.style-2 {
    padding: 50px 40px;
  }
}

@media (max-width: 991px) {
  .consultations-form.style-2 {
    margin-top: 30px;
  }
}

.consultations-form.style-2 p {
  color: <?=$ayar['renk']?>;
}

.consultations-form.style-2 form input, .consultations-form.style-2 form textarea {
  border-width: 2px;
  border-color: #e9e9eb;
  color: #211e3b;
  font-weight: 500;
  background-color: #fff;
}

.consultations-form.style-2 form input::-webkit-input-placeholder, .consultations-form.style-2 form textarea::-webkit-input-placeholder {
  color: #211e3b;
}

.consultations-form.style-2 form input:-ms-input-placeholder, .consultations-form.style-2 form textarea:-ms-input-placeholder {
  color: #211e3b;
}


.consultations-form.style-2 form input::-ms-input-placeholder, .consultations-form.style-2 form textarea::-ms-input-placeholder {
  color: #211e3b;
}

.consultations-form.style-2 form input::placeholder, .consultations-form.style-2 form textarea::placeholder {
  color: #211e3b;
}

.consultations-form.style-2 form input:hover, .consultations-form.style-2 form textarea:hover {
  border-color: <?=$ayar['renk']?>;
}

.consultations-form.style-2 form button {
  background-color: <?=$ayar['renk']?>;
  border-color: <?=$ayar['renk']?>;
  color: #fff;
  margin-top: 30px;
}

.consultations-form.style-2 form button i {
  margin-left: 10px;
}

.consultations-form p {
  text-transform: uppercase;
}

.consultations-form h1 {
  text-transform: capitalize;
  margin-top: 5px;
}

.consultations-form form input, .consultations-form form textarea {
  border-width: 1px;
  border-color: <?=$ayar['renk2']?>;
  border-style: solid;
  border-radius: 7px;
  width: 100%;
  font-size: 18px;
  font-weight: 500;
  line-height: 1;
  padding: 28px 30px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
  margin-top: 30px;
  background: transparent;
  color: #fff;
}

@media (max-width: 767px) {
  .consultations-form form input, .consultations-form form textarea {
    padding: 20px;
    font-size: 16px;
  }
}

.consultations-form form input:hover, .consultations-form form textarea:hover {
  border-color: #fff;
}

.consultations-form form input::-webkit-input-placeholder, .consultations-form form textarea::-webkit-input-placeholder {
  text-transform: capitalize;
  color: #fff;
}

.consultations-form form input:-ms-input-placeholder, .consultations-form form textarea:-ms-input-placeholder {
  text-transform: capitalize;
  color: #fff;
}

.consultations-form form input::-ms-input-placeholder, .consultations-form form textarea::-ms-input-placeholder {
  text-transform: capitalize;
  color: #fff;
}

.consultations-form form input::placeholder, .consultations-form form textarea::placeholder {
  text-transform: capitalize;
  color: #fff;
}

.consultations-form form textarea {
  min-height: 200px;
}

@media (max-width: 767px) {
  .consultations-form form textarea {
    min-height: 130px;
  }
}

.consultations-form form button {
  background-color: #fff;
  color: <?=$ayar['renk']?>;
  margin-top: 30px;
}

.consultations-form form button i {
  margin-left: 10px;
}

.footer-1 {
  background-color: #fff;
}

.footer-1 .footer-widgets {
  position: relative;
  z-index: 1;
}

.footer-widgets {
  padding-top: 55px;
  padding-bottom: 100px;
}

@media (max-width: 767px) {
  .footer-widgets {
    padding-bottom: 80px;
    padding-top: 35px;
  }
}

.footer-2 {
  background: #f2f7fd;
  position: relative;
}

.footer-2::before {
  position: absolute;
  width: 100%;
  height: 140px;
  bottom: 100%;
  left: 0;
  content: "";
  background-color: #f2f7fd;
  z-index: -1;
}

.footer-2 .social-link a {
  display: inline-block;
  width: 36px;
  height: 36px;
  line-height: 39px;
  border-radius: 50%;
  background-color: #dae9f9;
  margin: 0 4px;
  text-align: center;
  font-size: 14px;
}

.footer-2 .social-link a:hover {
  background-color: <?=$ayar['renk']?>;
  color: #fff;
}

.footer-wrap .footer-bottom .footer-bottom-content {
  border-top: 1px solid #efeff1;
  padding: 30px 0px;
}

.footer-wrap .footer-bottom a {
  color: <?=$ayar['renk']?>;
}

.footer-wrap .single-footer-wid {
  margin-top: 40px;
}

.footer-wrap .single-footer-wid .wid-title {
  margin-bottom: 30px;
}

.footer-wrap .single-footer-wid.site_info_box {
  text-align: center;
  -webkit-box-shadow: 0px 10px 20px 0px rgba(0, 0, 0, 0.2);
          box-shadow: 0px 10px 20px 0px rgba(0, 0, 0, 0.2);
  background-color: #fff;
  position: relative;
  margin-right: 40px;
  padding: 60px 40px;
  margin-top: -80px;
  z-index: 9;
}

.footer-wrap .single-footer-wid.site_info_box .f_logo {
  margin-bottom: 30px;
  display: block;
}

.footer-wrap .single-footer-wid.site_info_box::before {
  position: absolute;
  width: 100%;
  height: 6px;
  background-color: #ff5e14;
  content: "";
  top: 0;
  left: 0;
}

.footer-wrap .single-footer-wid.site_info_box p {
  color: #696969;
  font-size: 14px;
}

.footer-wrap .single-footer-wid.site_info_box .social_link {
  margin-top: 40px;
}

@media (max-width: 767px) {
  .footer-wrap .single-footer-wid.site_info_box .social_link {
    margin-top: 30px;
  }
}

.footer-wrap .single-footer-wid.site_info_box .social_link a {
  background-color: #211e3b;
  width: 40px;
  height: 40px;
  line-height: 41px;
  border-radius: 50px;
  font-size: 14px;
  -webkit-transition: all 0.3s ease-in-out;
  transition: all 0.3s ease-in-out;
  text-align: center;
  display: inline-block;
  color: #211e3b;
  margin-right: 5px;
}

.footer-wrap .single-footer-wid.site_info_box .social_link a:hover {
  color: #fff;
  background-color: #ff5e14;
}

.footer-wrap .single-footer-wid.site_info_widget .single-contact-info {
  overflow: auto;
  margin-bottom: 20px;
  border-bottom: 1px solid #282828;
  padding-bottom: 25px;
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
}

.footer-wrap .single-footer-wid.site_info_widget .single-contact-info:last-child {
  border: 0;
}

.footer-wrap .single-footer-wid.site_info_widget .single-contact-info:hover .icon {
  background-color: #fff;
  color: <?=$ayar['renk']?>;
}

.footer-wrap .single-footer-wid.site_info_widget .single-contact-info p {
  font-size: 18px;
  font-weight: 700;
  color: #fff;
}

.footer-wrap .single-footer-wid.site_info_widget .single-contact-info span {
  display: block;
  color: #cacaca;
  font-size: 14px;
}

.footer-wrap .single-footer-wid.site_info_widget .single-contact-info .icon {
  width: 40px;
  height: 40px;
  line-height: 40px;
  color: #000;
  background-color: <?=$ayar['renk']?>;
  float: left;
  text-align: center;
  overflow: hidden;
  font-size: 16px;
  margin-right: 20px;
  border-radius: 10px;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.footer-wrap .single-footer-wid .social_link {
  margin-top: 40px;
}

@media (max-width: 767px) {
  .footer-wrap .single-footer-wid .social_link {
    margin-top: 30px;
  }
}

.footer-wrap .single-footer-wid .social_link a {
  background-color: #0f0f0f;
  width: 60px;
  height: 60px;
  line-height: 60px;
  border-radius: 10px;
  font-size: 16px;
  -webkit-transition: all 0.3s ease-in-out;
  transition: all 0.3s ease-in-out;
  text-align: center;
  display: inline-block;
  color: #fff;
  margin-right: 5px;
}

.footer-wrap .single-footer-wid .social_link a:hover {
  color: #fff;
  background-color: <?=$ayar['renk']?>;
}

.footer-wrap .single-footer-wid ul li {
  position: relative;
  z-index: 1;
  padding-left: 20px;
}

.footer-wrap .single-footer-wid ul li::before {
  position: absolute;
  content: "\f101";
  left: 0;
  font-family: "Font Awesome 5 Pro";
}

.footer-wrap .single-footer-wid ul li > a {
  color: #696969;
  margin-bottom: 15px;
  display: block;
  -webkit-transition: all 0.3s;
  transition: all 0.3s;
  font-weight: 500;
  text-transform: capitalize;
}

@media (max-width: 1191px) {
  .footer-wrap .single-footer-wid ul li > a {
    margin-bottom: 20px;
  }
}

@media (max-width: 767px) {
  .footer-wrap .single-footer-wid ul li > a {
    margin-bottom: 15px;
  }
}

.footer-wrap .single-footer-wid ul li > a:hover {
  color: <?=$ayar['renk']?>;
  padding-left: 10px;
}

.footer-wrap .single-footer-wid ul li:last-child a {
  margin-bottom: 0;
}

.footer-3 {
  position: relative;
  padding-top: 130px;
  margin-top: -130px;
  z-index: 1;
}

.footer-3 h1, .footer-3 h2, .footer-3 h3, .footer-3 h4 {
  color: #fff !important;
}

.footer-3 a, .footer-3 p, .footer-3 span {
  color: #b9b9bb !important;
}

.footer-3::before {
  position: absolute;
  width: 100%;
  height: 100%;
  bottom: 0;
  left: 0;
  content: "";
  background: #09071b;
  opacity: .94;
  z-index: -1;
}

.footer-3 .social-link a {
  display: inline-block;
  width: 36px;
  height: 36px;
  line-height: 39px;
  border-radius: 50%;
  background-color: #dae9f9;
  margin: 0 4px;
  text-align: center;
  font-size: 14px;
  color: <?=$ayar['renk']?> !important;
}

.footer-3 .social-link a:hover {
  background-color: <?=$ayar['renk']?>;
  color: #fff !important;
}

.footer-3 .footer-bottom-content {
  border-top: 1px solid #1a192b !important;
}

.footer-menu ul li {
  display: inline-block;
}

.footer-menu ul li a {
  display: inline-block;
  margin-left: 40px;
}

.recent_post_widget .recent-post-list .single-recent-post {
  overflow: hidden;
  -webkit-box-sizing: border-box;
          box-sizing: border-box;
  margin-bottom: 25px;
}

.recent_post_widget .recent-post-list .single-recent-post:last-child {
  margin-bottom: 0;
}

.recent_post_widget .recent-post-list .single-recent-post .thumb {
  background-color: #eee;
  width: 80px;
  height: 80px;
  overflow: hidden;
  float: left;
  margin-right: 20px;
  border-radius: 7px;
}

.recent_post_widget .recent-post-list .single-recent-post .post-data {
  margin-top: -5px;
}

.recent_post_widget .recent-post-list .single-recent-post .post-data span {
  font-size: 14px;
  line-height: 1;
}

.recent_post_widget .recent-post-list .single-recent-post .post-data span i {
  margin-right: 5px;
}

.recent_post_widget .recent-post-list .single-recent-post .post-data h5 {
  letter-spacing: -1px;
}

.recent_post_widget .recent-post-list .single-recent-post .post-data h5:hover {
  color: <?=$ayar['renk']?>;
}

.newsletter_widget .newsletter_box form {
  height: 64px;
  position: relative;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  margin-top: 25px;
  margin-bottom: 10px;
}

.newsletter_widget .newsletter_box form input {
  width: 75%;
  position: relative;
  background: #f5f5f5;
  padding-left: 25px;
  padding-right: 15px;
  line-height: 1;
  color: <?=$ayar['renk']?>;
  border-radius: 7px;
  font-size: 16px;
}

.newsletter_widget .newsletter_box form input::-webkit-input-placeholder {
  color: #696969;
  text-transform: capitalize;
}

.newsletter_widget .newsletter_box form input:-ms-input-placeholder {
  color: #696969;
  text-transform: capitalize;
}

.newsletter_widget .newsletter_box form input::-ms-input-placeholder {
  color: #696969;
  text-transform: capitalize;
}

.newsletter_widget .newsletter_box form input::placeholder {
  color: #696969;
  text-transform: capitalize;
}

.newsletter_widget .newsletter_box form button {
  width: 25%;
  height: 100%;
  background: <?=$ayar['renk']?>;
  color: #fff;
  display: inline-block;
  border-radius: 0px 10px 10px 0px;
  font-size: 22px;
  line-height: 1;
  -webkit-transition: all .3s ease-in-out;
  transition: all .3s ease-in-out;
}

.newsletter_widget .newsletter_box form button:hover {
  color: #000;
}

.newsletter_widget .newsletter_box span {
  color: #cacaca;
}

.contact_widget_2 .contact-us .single-contact-info {
  overflow: hidden;
  margin-bottom: 15px;
}

.contact_widget_2 .contact-us .single-contact-info:last-child {
  margin-bottom: 0;
}

.contact_widget_2 .contact-us .single-contact-info .icon {
  float: left;
  margin-right: 15px;
  overflow: hidden;
  color: <?=$ayar['renk']?>;
  font-size: 24px;
  padding-right: 5px;
}

.contact_widget_2 .contact-us .single-contact-info .contact-info {
  overflow: hidden;
}

.contact_widget_2 .contact-us .single-contact-info .contact-info p {
  margin-top: -5px;
}
/*# sourceMappingURL=style.css.map */
</style>